/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class JdbcbasedSchemaProvider
extends SchemaProvider {
    private Schema sourceSchema;
    private Map<String, String> options = new HashMap<String, String>();

    public JdbcbasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        this.options.put("url", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.connection.url"));
        this.options.put("driver", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.driver.type"));
        this.options.put("user", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.username"));
        this.options.put("password", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.password"));
        this.options.put("dbtable", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.dbtable"));
        this.options.put("queryTimeout", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.timeout", "0"));
        this.options.put("nullable", props.getString("hoodie.deltastreamer.schemaprovider.source.schema.jdbc.nullable", "true"));
    }

    @Override
    public Schema getSourceSchema() {
        if (this.sourceSchema != null) {
            return this.sourceSchema;
        }
        try {
            this.sourceSchema = UtilHelpers.getJDBCSchema(this.options);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get Schema through jdbc. ", (Throwable)e);
        }
        return this.sourceSchema;
    }

    public static class Config {
        private static final String SOURCE_SCHEMA_JDBC_CONNECTION_URL = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.connection.url";
        private static final String SOURCE_SCHEMA_JDBC_DRIVER_TYPE = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.driver.type";
        private static final String SOURCE_SCHEMA_JDBC_USERNAME = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.username";
        private static final String SOURCE_SCHEMA_JDBC_PASSWORD = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.password";
        private static final String SOURCE_SCHEMA_JDBC_DBTABLE = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.dbtable";
        private static final String SOURCE_SCHEMA_JDBC_TIMEOUT = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.timeout";
        private static final String SOURCE_SCHEMA_JDBC_NULLABLE = "hoodie.deltastreamer.schemaprovider.source.schema.jdbc.nullable";
    }
}

