/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.JsonSource;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

public class JsonDFSSource
extends JsonSource {
    private final DFSPathSelector pathSelector;

    public JsonDFSSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        this.pathSelector = DFSPathSelector.createSourceSelector(props, sparkContext.hadoopConfiguration());
    }

    @Override
    protected InputBatch<JavaRDD<String>> fetchNewData(Option<String> lastCkptStr, long sourceLimit) {
        Pair<Option<String>, String> selPathsWithMaxModificationTime = this.pathSelector.getNextFilePathsAndMaxModificationTime(this.sparkContext, lastCkptStr, sourceLimit);
        return (InputBatch)((Option)selPathsWithMaxModificationTime.getLeft()).map(pathStr -> new InputBatch(Option.of(this.fromFiles((String)pathStr)), (String)selPathsWithMaxModificationTime.getRight())).orElse(new InputBatch(Option.empty(), (String)selPathsWithMaxModificationTime.getRight()));
    }

    private JavaRDD<String> fromFiles(String pathStr) {
        return this.sparkContext.textFile(pathStr);
    }
}

