/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.HoodieIncrSource;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class S3EventsHoodieIncrSource
extends HoodieIncrSource {
    private static final Logger LOG = LogManager.getLogger(S3EventsHoodieIncrSource.class);

    public S3EventsHoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        DataSourceUtils.checkRequiredProperties((TypedProperties)this.props, Collections.singletonList("hoodie.deltastreamer.source.hoodieincr.path"));
        String srcPath = this.props.getString("hoodie.deltastreamer.source.hoodieincr.path");
        int numInstantsPerFetch = this.props.getInteger("hoodie.deltastreamer.source.hoodieincr.num_instants", HoodieIncrSource.Config.DEFAULT_NUM_INSTANTS_PER_FETCH.intValue());
        boolean readLatestOnMissingCkpt = this.props.getBoolean("hoodie.deltastreamer.source.hoodieincr.read_latest_on_missing_ckpt", HoodieIncrSource.Config.DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT.booleanValue());
        Option<String> beginInstant = lastCkptStr.isPresent() ? (((String)lastCkptStr.get()).isEmpty() ? Option.empty() : lastCkptStr) : Option.empty();
        Pair<String, String> instantEndpts = IncrSourceHelper.calculateBeginAndEndInstants(this.sparkContext, srcPath, numInstantsPerFetch, beginInstant, readLatestOnMissingCkpt);
        if (((String)instantEndpts.getKey()).equals(instantEndpts.getValue())) {
            LOG.warn((Object)("Already caught up. Begin Checkpoint was :" + (String)instantEndpts.getKey()));
            return Pair.of((Object)Option.empty(), (Object)instantEndpts.getKey());
        }
        DataFrameReader metaReader = this.sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions.BEGIN_INSTANTTIME().key(), (String)instantEndpts.getLeft()).option(DataSourceReadOptions.END_INSTANTTIME().key(), (String)instantEndpts.getRight());
        Dataset source = metaReader.load(srcPath);
        String filter = "s3.object.size > 0";
        if (!StringUtils.isNullOrEmpty((String)this.props.getString("hoodie.deltastreamer.source.s3incr.key.prefix"))) {
            filter = filter + " and s3.object.key like '" + this.props.getString("hoodie.deltastreamer.source.s3incr.key.prefix") + "%'";
        }
        String s3FS = this.props.getString("hoodie.deltastreamer.source.s3incr.fs.prefix", "s3").toLowerCase();
        String s3Prefix = s3FS + "://";
        List cloudMetaDf = source.filter(filter).select("s3.bucket.name", new String[]{"s3.object.key"}).distinct().collectAsList();
        boolean checkExists = this.props.getBoolean("hoodie.deltastreamer.source.s3incr.check.file.exists", Config.DEFAULT_ENABLE_EXISTS_CHECK.booleanValue());
        ArrayList<String> cloudFiles = new ArrayList<String>();
        for (Row row : cloudMetaDf) {
            String bucket = row.getString(0);
            String filePath = s3Prefix + bucket + "/" + row.getString(1);
            if (checkExists) {
                FileSystem fs = FSUtils.getFs((String)(s3Prefix + bucket), (Configuration)this.sparkSession.sparkContext().hadoopConfiguration());
                try {
                    if (!fs.exists(new Path(filePath))) continue;
                    cloudFiles.add(filePath);
                }
                catch (IOException e) {
                    LOG.error((Object)String.format("Error while checking path exists for %s ", filePath), (Throwable)e);
                }
                continue;
            }
            cloudFiles.add(filePath);
        }
        String fileFormat = this.props.getString("hoodie.deltastreamer.source.hoodieincr.file.format", "parquet");
        Option dataset = Option.empty();
        if (!cloudFiles.isEmpty()) {
            dataset = Option.of((Object)this.sparkSession.read().format(fileFormat).load(cloudFiles.toArray(new String[0])));
        }
        return Pair.of((Object)dataset, (Object)instantEndpts.getRight());
    }

    static class Config {
        static final String ENABLE_EXISTS_CHECK = "hoodie.deltastreamer.source.s3incr.check.file.exists";
        static final Boolean DEFAULT_ENABLE_EXISTS_CHECK = false;
        static final String S3_KEY_PREFIX = "hoodie.deltastreamer.source.s3incr.key.prefix";
        static final String S3_FS_PREFIX = "hoodie.deltastreamer.source.s3incr.fs.prefix";

        Config() {
        }
    }
}

