/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class SqlSource
extends RowSource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(SqlSource.class);
    private final String sourceSql;
    private final SparkSession spark;

    public SqlSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        DataSourceUtils.checkRequiredProperties((TypedProperties)props, Collections.singletonList("hoodie.deltastreamer.source.sql.sql.query"));
        this.sourceSql = props.getString("hoodie.deltastreamer.source.sql.sql.query");
        this.spark = sparkSession;
    }

    @Override
    protected Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        LOG.debug((Object)this.sourceSql);
        Dataset source = this.spark.sql(this.sourceSql);
        LOG.debug((Object)source.showString(10, 0, true));
        if (Arrays.asList(source.columns()).contains("_hoodie_commit_time")) {
            source = source.drop((String[])HoodieRecord.HOODIE_META_COLUMNS.stream().filter(x -> !x.equals("_hoodie_partition_path")).toArray(String[]::new));
        }
        return Pair.of((Object)Option.of((Object)source), null);
    }

    private static class Config {
        private static final String SOURCE_SQL = "hoodie.deltastreamer.source.sql.sql.query";

        private Config() {
        }
    }
}

