/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Row;

public class IncrSourceHelper {
    private static String getStrictlyLowerTimestamp(String timestamp) {
        long ts = Long.parseLong(timestamp);
        ValidationUtils.checkArgument((ts > 0L ? 1 : 0) != 0, (String)"Timestamp must be positive");
        long lower = ts - 1L;
        return "" + lower;
    }

    public static Pair<String, String> calculateBeginAndEndInstants(JavaSparkContext jssc, String srcBasePath, int numInstantsPerFetch, Option<String> beginInstant, boolean readLatestOnMissingBeginInstant) {
        ValidationUtils.checkArgument((numInstantsPerFetch > 0 ? 1 : 0) != 0, (String)"Make sure the config hoodie.deltastreamer.source.hoodieincr.num_instants is set to a positive value");
        HoodieTableMetaClient srcMetaClient = HoodieTableMetaClient.builder().setConf(jssc.hadoopConfiguration()).setBasePath(srcBasePath).setLoadActiveTimelineOnLoad(true).build();
        HoodieTimeline activeCommitTimeline = srcMetaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants();
        String beginInstantTime = (String)beginInstant.orElseGet(() -> {
            if (readLatestOnMissingBeginInstant) {
                Option lastInstant = activeCommitTimeline.lastInstant();
                return (String)lastInstant.map(hoodieInstant -> IncrSourceHelper.getStrictlyLowerTimestamp(hoodieInstant.getTimestamp())).orElse((Object)"000");
            }
            throw new IllegalArgumentException("Missing begin instant for incremental pull. For reading from latest committed instant set hoodie.deltastreamer.source.hoodieincr.read_latest_on_missing_ckpt to true");
        });
        Option nthInstant = Option.fromJavaOptional(activeCommitTimeline.findInstantsAfter(beginInstantTime, numInstantsPerFetch).getInstants().reduce((x, y) -> y));
        return Pair.of((Object)beginInstantTime, (Object)nthInstant.map(HoodieInstant::getTimestamp).orElse((Object)beginInstantTime));
    }

    public static void validateInstantTime(Row row, String instantTime, String sinceInstant, String endInstant) {
        Objects.requireNonNull(instantTime);
        ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)instantTime, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)sinceInstant), (String)("Instant time(_hoodie_commit_time) in row (" + row + ") was : " + instantTime + "but expected to be between " + sinceInstant + "(excl) - " + endInstant + "(incl)"));
        ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)instantTime, (BiPredicate)HoodieTimeline.LESSER_THAN_OR_EQUALS, (String)endInstant), (String)("Instant time(_hoodie_commit_time) in row (" + row + ") was : " + instantTime + "but expected to be between " + sinceInstant + "(excl) - " + endInstant + "(incl)"));
    }
}

