/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.FileProvXAttrBufferDataAccess;
import io.hops.metadata.hdfs.entity.FileProvXAttrBufferEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;

public class FileProvXAttrBufferClusterj
implements TablesDef.FileProvXAttrBufferTableDef,
FileProvXAttrBufferDataAccess<FileProvXAttrBufferEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    private FileProvXAttrBufferEntryDto createPersistable(FileProvXAttrBufferEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        FileProvXAttrBufferEntryDto dto = session.newInstance(FileProvXAttrBufferEntryDto.class);
        dto.setINodeId(logEntry.getInodeId());
        dto.setNamespace(logEntry.getNamespace());
        dto.setName(logEntry.getName());
        dto.setINodeLogicalTime(logEntry.getINodeLogicalTime());
        dto.setValue(logEntry.getValue());
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FileProvXAttrBufferEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        FileProvXAttrBufferEntryDto dto = null;
        try {
            dto = this.createPersistable(logEntry);
            session.savePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<FileProvXAttrBufferEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<FileProvXAttrBufferEntryDto> added = new ArrayList<FileProvXAttrBufferEntryDto>(logEntries.size());
        try {
            for (FileProvXAttrBufferEntry logEntry : logEntries) {
                added.add(this.createPersistable(logEntry));
            }
            session.savePersistentAll(added);
        }
        finally {
            session.release(added);
        }
    }

    @PersistenceCapable(table="hdfs_file_provenance_xattrs_buffer")
    public static interface FileProvXAttrBufferEntryDto {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="namespace")
        public byte getNamespace();

        public void setNamespace(byte var1);

        @PrimaryKey
        @Column(name="name")
        public String getName();

        public void setName(String var1);

        @PrimaryKey
        @Column(name="inode_logical_time")
        public int getINodeLogicalTime();

        public void setINodeLogicalTime(int var1);

        @Column(name="value")
        public byte[] getValue();

        public void setValue(byte[] var1);
    }
}

