/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb;

import com.mysql.clusterj.LockMode;
import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.election.dal.HdfsLeDescriptorDataAccess;
import io.hops.metadata.election.dal.YarnLeDescriptorDataAccess;
import io.hops.metadata.hdfs.dal.AceDataAccess;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.BlockLookUpDataAccess;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.metadata.hdfs.dal.CachePoolDataAccess;
import io.hops.metadata.hdfs.dal.CachedBlockDataAccess;
import io.hops.metadata.hdfs.dal.CorruptReplicaDataAccess;
import io.hops.metadata.hdfs.dal.EncodingJobsDataAccess;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.dal.ExcessReplicaDataAccess;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.dal.INodeAttributesDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.LeaseDataAccess;
import io.hops.metadata.hdfs.dal.LeasePathDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.dal.MisReplicatedRangeQueueDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.dal.PendingBlockDataAccess;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.dal.RepairJobsDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaUnderConstructionDataAccess;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.dal.SafeBlocksDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.StorageDataAccess;
import io.hops.metadata.hdfs.dal.StorageIdMapDataAccess;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.ndb.DBSession;
import io.hops.metadata.ndb.DBSessionProvider;
import io.hops.metadata.ndb.dalimpl.election.HdfsLeaderClusterj;
import io.hops.metadata.ndb.dalimpl.election.YarnLeaderClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.AceClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.BlockChecksumClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.BlockInfoClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.CacheDirectiveClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.CachePoolClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.CachedBlockClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.CorruptReplicaClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.EncodingStatusClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.ExcessReplicaClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.HashBucketClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.INodeAttributesClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.INodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.InMemoryFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.InvalidatedBlockClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LargeOnDiskFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LeaseClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LeasePathClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.MediumOnDiskFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.OnGoingSubTreeOpsClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.PendingBlockClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.QuotaUpdateClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.ReplicaClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.ReplicaUnderConstructionClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.RetryCacheEntryClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.SmallOnDiskFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.UnderReplicatedBlockClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.VariableClusterj;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.ndb.wrapper.HopsTransaction;
import io.hops.metadata.yarn.dal.ContainerIdToCleanDataAccess;
import io.hops.metadata.yarn.dal.ContainerStatusDataAccess;
import io.hops.metadata.yarn.dal.ContainerToDecreaseDataAccess;
import io.hops.metadata.yarn.dal.ContainerToSignalDataAccess;
import io.hops.metadata.yarn.dal.NextHeartbeatDataAccess;
import io.hops.metadata.yarn.dal.PendingEventDataAccess;
import io.hops.metadata.yarn.dal.RMLoadDataAccess;
import io.hops.metadata.yarn.dal.RMNodeApplicationsDataAccess;
import io.hops.metadata.yarn.dal.RMNodeDataAccess;
import io.hops.metadata.yarn.dal.ReservationStateDataAccess;
import io.hops.metadata.yarn.dal.ResourceDataAccess;
import io.hops.metadata.yarn.dal.UpdatedContainerInfoDataAccess;
import io.hops.metadata.yarn.dal.quota.ContainersCheckPointsDataAccess;
import io.hops.metadata.yarn.dal.quota.ContainersLogsDataAccess;
import io.hops.metadata.yarn.dal.quota.PriceMultiplicatorDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectQuotaDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectsDailyCostDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationAttemptStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationKeyDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationTokenDataAccess;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterjConnector
implements StorageConnector<DBSession> {
    private static final ClusterjConnector instance = new ClusterjConnector();
    private static boolean isInitialized = false;
    private DBSessionProvider dbSessionProvider = null;
    static ThreadLocal<DBSession> sessions = new ThreadLocal();
    static final Log LOG = LogFactory.getLog(ClusterjConnector.class);
    private String clusterConnectString;
    private String databaseName;

    private ClusterjConnector() {
    }

    public static ClusterjConnector getInstance() {
        return instance;
    }

    public void setConfiguration(Properties conf) throws StorageException {
        if (isInitialized) {
            LOG.warn((Object)"SessionFactory is already initialized");
            return;
        }
        this.clusterConnectString = (String)conf.get("com.mysql.clusterj.connectstring");
        LOG.info((Object)("Database connect string: " + conf.get("com.mysql.clusterj.connectstring")));
        this.databaseName = (String)conf.get("com.mysql.clusterj.database");
        LOG.info((Object)("Database name: " + conf.get("com.mysql.clusterj.database")));
        LOG.info((Object)("Max Transactions: " + conf.get("com.mysql.clusterj.max.transactions")));
        int initialPoolSize = Integer.parseInt((String)conf.get("io.hops.session.pool.size"));
        int reuseCount = Integer.parseInt((String)conf.get("io.hops.session.reuse.count"));
        this.dbSessionProvider = new DBSessionProvider(conf, reuseCount, initialPoolSize);
        isInitialized = true;
    }

    public HopsSession obtainSession() throws StorageException {
        DBSession dbSession = sessions.get();
        if (dbSession == null) {
            dbSession = this.dbSessionProvider.getSession();
            sessions.set(dbSession);
        }
        return dbSession.getSession();
    }

    private void returnSession(boolean error) throws StorageException {
        DBSession dbSession = sessions.get();
        sessions.remove();
        this.dbSessionProvider.returnSession(dbSession, error);
    }

    public void beginTransaction() throws StorageException {
        HopsSession session = this.obtainSession();
        if (session.currentTransaction().isActive()) {
            LOG.fatal((Object)"Prevented starting transaction within a transaction.");
            throw new Error("Can not start Tx inside another Tx");
        }
        session.currentTransaction().begin();
    }

    public void commit() throws StorageException {
        HopsSession session = null;
        boolean dbError = false;
        try {
            session = this.obtainSession();
            HopsTransaction tx = session.currentTransaction();
            if (!tx.isActive()) {
                throw new StorageException("The transaction is not began!");
            }
            tx.commit();
        }
        catch (StorageException e) {
            dbError = true;
            throw e;
        }
        finally {
            this.returnSession(dbError);
        }
    }

    public void rollback() throws StorageException {
        HopsSession session = null;
        boolean dbError = false;
        try {
            session = this.obtainSession();
            HopsTransaction tx = session.currentTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (StorageException e) {
            dbError = true;
            throw e;
        }
        finally {
            this.returnSession(dbError);
        }
    }

    public boolean formatStorage() throws StorageException {
        return this.formatAll(true);
    }

    public boolean formatYarnStorage() throws StorageException {
        return this.formatYarn(true);
    }

    public boolean formatHDFSStorage() throws StorageException {
        return this.formatHDFS(true);
    }

    public boolean formatStorage(Class<? extends EntityDataAccess> ... das) throws StorageException {
        return this.format(true, das);
    }

    public boolean isTransactionActive() throws StorageException {
        return this.obtainSession().currentTransaction().isActive();
    }

    public void stopStorage() throws StorageException {
        this.dbSessionProvider.stop();
    }

    public void readLock() throws StorageException {
        HopsSession session = this.obtainSession();
        session.setLockMode(LockMode.SHARED);
    }

    public void writeLock() throws StorageException {
        HopsSession session = this.obtainSession();
        session.setLockMode(LockMode.EXCLUSIVE);
    }

    public void readCommitted() throws StorageException {
        HopsSession session = this.obtainSession();
        session.setLockMode(LockMode.READ_COMMITTED);
    }

    public void setPartitionKey(Class className, Object key) throws StorageException {
        Class cls = null;
        if (className == BlockInfoDataAccess.class) {
            cls = BlockInfoClusterj.BlockInfoDTO.class;
        } else if (className == PendingBlockDataAccess.class) {
            cls = PendingBlockClusterj.PendingBlockDTO.class;
        } else if (className == ReplicaUnderConstructionDataAccess.class) {
            cls = ReplicaUnderConstructionClusterj.ReplicaUcDTO.class;
        } else if (className == INodeDataAccess.class) {
            cls = INodeClusterj.InodeDTO.class;
        } else if (className == INodeAttributesDataAccess.class) {
            cls = INodeAttributesClusterj.INodeAttributesDTO.class;
        } else if (className == LeaseDataAccess.class) {
            cls = LeaseClusterj.LeaseDTO.class;
        } else if (className == LeasePathDataAccess.class) {
            cls = LeasePathClusterj.LeasePathsDTO.class;
        } else if (className == HdfsLeDescriptorDataAccess.class) {
            cls = HdfsLeaderClusterj.HdfsLeaderDTO.class;
        } else if (className == YarnLeDescriptorDataAccess.class) {
            cls = YarnLeaderClusterj.YarnLeaderDTO.class;
        } else if (className == ReplicaDataAccess.class) {
            cls = ReplicaClusterj.ReplicaDTO.class;
        } else if (className == CorruptReplicaDataAccess.class) {
            cls = CorruptReplicaClusterj.CorruptReplicaDTO.class;
        } else if (className == ExcessReplicaDataAccess.class) {
            cls = ExcessReplicaClusterj.ExcessReplicaDTO.class;
        } else if (className == InvalidateBlockDataAccess.class) {
            cls = InvalidatedBlockClusterj.InvalidateBlocksDTO.class;
        } else if (className == UnderReplicatedBlockDataAccess.class) {
            cls = UnderReplicatedBlockClusterj.UnderReplicatedBlocksDTO.class;
        } else if (className == VariableDataAccess.class) {
            cls = VariableClusterj.VariableDTO.class;
        } else if (className == QuotaUpdateDataAccess.class) {
            cls = QuotaUpdateClusterj.QuotaUpdateDTO.class;
        } else if (className == EncodingStatusDataAccess.class) {
            cls = EncodingStatusClusterj.EncodingStatusDto.class;
        } else if (className == BlockChecksumDataAccess.class) {
            cls = BlockChecksumClusterj.BlockChecksumDto.class;
        } else if (className == OngoingSubTreeOpsDataAccess.class) {
            cls = OnGoingSubTreeOpsClusterj.OnGoingSubTreeOpsDTO.class;
        } else if (className == HashBucketDataAccess.class) {
            cls = HashBucketClusterj.HashBucketDTO.class;
        } else if (className == InMemoryInodeDataAccess.class) {
            cls = InMemoryFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == SmallOnDiskInodeDataAccess.class) {
            cls = SmallOnDiskFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == MediumOnDiskInodeDataAccess.class) {
            cls = MediumOnDiskFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == LargeOnDiskInodeDataAccess.class) {
            cls = LargeOnDiskFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == AceDataAccess.class) {
            cls = AceClusterJ.AceDto.class;
        } else if (className == RetryCacheEntryDataAccess.class) {
            cls = RetryCacheEntryClusterj.RetryCacheEntryDTO.class;
        } else if (className == CacheDirectiveDataAccess.class) {
            cls = CacheDirectiveClusterj.CacheDirectiveDTO.class;
        } else if (className == CachePoolDataAccess.class) {
            cls = CachePoolClusterJ.CachePoolDTO.class;
        } else if (className == CachedBlockDataAccess.class) {
            cls = CachedBlockClusterJ.CachedBlockDTO.class;
        }
        HopsSession session = this.obtainSession();
        session.setPartitionKey(cls, key);
        session.flush();
    }

    public boolean formatAllStorageNonTransactional() throws StorageException {
        return this.formatAll(false);
    }

    public boolean formatYarnStorageNonTransactional() throws StorageException {
        return this.formatAll(false);
    }

    public boolean formatHDFSStorageNonTransactional() throws StorageException {
        return this.formatHDFS(false);
    }

    private boolean formatYarn(boolean transactional) throws StorageException {
        return this.format(transactional, ContainerIdToCleanDataAccess.class, ContainerStatusDataAccess.class, RMNodeDataAccess.class, RMNodeApplicationsDataAccess.class, UpdatedContainerInfoDataAccess.class, YarnLeDescriptorDataAccess.class, RMLoadDataAccess.class, PendingEventDataAccess.class, NextHeartbeatDataAccess.class, ApplicationStateDataAccess.class, ApplicationAttemptStateDataAccess.class, DelegationKeyDataAccess.class, DelegationTokenDataAccess.class, ProjectQuotaDataAccess.class, ContainersLogsDataAccess.class, ContainersCheckPointsDataAccess.class, ProjectsDailyCostDataAccess.class, PriceMultiplicatorDataAccess.class, ResourceDataAccess.class, ContainerToSignalDataAccess.class, ContainerToDecreaseDataAccess.class, ReservationStateDataAccess.class);
    }

    private boolean formatHDFS(boolean transactional) throws StorageException {
        return this.format(transactional, INodeDataAccess.class, InMemoryInodeDataAccess.class, SmallOnDiskInodeDataAccess.class, MediumOnDiskInodeDataAccess.class, LargeOnDiskInodeDataAccess.class, BlockInfoDataAccess.class, LeaseDataAccess.class, LeasePathDataAccess.class, ReplicaDataAccess.class, ReplicaUnderConstructionDataAccess.class, InvalidateBlockDataAccess.class, ExcessReplicaDataAccess.class, PendingBlockDataAccess.class, CorruptReplicaDataAccess.class, UnderReplicatedBlockDataAccess.class, HdfsLeDescriptorDataAccess.class, INodeAttributesDataAccess.class, StorageIdMapDataAccess.class, BlockLookUpDataAccess.class, SafeBlocksDataAccess.class, MisReplicatedRangeQueueDataAccess.class, QuotaUpdateDataAccess.class, EncodingStatusDataAccess.class, BlockChecksumDataAccess.class, OngoingSubTreeOpsDataAccess.class, MetadataLogDataAccess.class, EncodingJobsDataAccess.class, RepairJobsDataAccess.class, UserDataAccess.class, GroupDataAccess.class, UserGroupDataAccess.class, VariableDataAccess.class, HashBucketDataAccess.class, StorageDataAccess.class, AceDataAccess.class, RetryCacheEntryDataAccess.class, CacheDirectiveDataAccess.class, CachePoolDataAccess.class, CachedBlockDataAccess.class);
    }

    private boolean formatAll(boolean transactional) throws StorageException {
        if (!this.formatHDFS(transactional)) {
            return false;
        }
        if (!this.formatYarn(transactional)) {
            return false;
        }
        return this.format(transactional, VariableDataAccess.class);
    }

    private boolean format(boolean transactional, Class<? extends EntityDataAccess> ... das) throws StorageException {
        int RETRIES = 5;
        for (int i = 0; i < 5; ++i) {
            try {
                for (Class<? extends EntityDataAccess> e : das) {
                    if (e == StorageDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_storages");
                        continue;
                    }
                    if (e == INodeDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_inodes");
                        continue;
                    }
                    if (e == InMemoryInodeDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_inmemory_file_inode_data");
                        continue;
                    }
                    if (e == SmallOnDiskInodeDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_ondisk_small_file_inode_data");
                        continue;
                    }
                    if (e == MediumOnDiskInodeDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_ondisk_medium_file_inode_data");
                        continue;
                    }
                    if (e == LargeOnDiskInodeDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_ondisk_large_file_inode_data");
                        continue;
                    }
                    if (e == BlockInfoDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_block_infos");
                        continue;
                    }
                    if (e == LeaseDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_leases");
                        continue;
                    }
                    if (e == LeasePathDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_lease_paths");
                        continue;
                    }
                    if (e == OngoingSubTreeOpsDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_on_going_sub_tree_ops");
                        continue;
                    }
                    if (e == ReplicaDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_replicas");
                        continue;
                    }
                    if (e == ReplicaUnderConstructionDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_replica_under_constructions");
                        continue;
                    }
                    if (e == InvalidateBlockDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_invalidated_blocks");
                        continue;
                    }
                    if (e == ExcessReplicaDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_excess_replicas");
                        continue;
                    }
                    if (e == PendingBlockDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_pending_blocks");
                        continue;
                    }
                    if (e == CorruptReplicaDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_corrupt_replicas");
                        continue;
                    }
                    if (e == UnderReplicatedBlockDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_under_replicated_blocks");
                        continue;
                    }
                    if (e == HdfsLeDescriptorDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_le_descriptors");
                        continue;
                    }
                    if (e == INodeAttributesDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_inode_attributes");
                        continue;
                    }
                    if (e == VariableDataAccess.class) {
                        HopsSession session = this.obtainSession();
                        session.currentTransaction().begin();
                        session.deletePersistentAll(VariableClusterj.VariableDTO.class);
                        for (Variable.Finder varType : Variable.Finder.values()) {
                            LOG.info((Object)("write varialbe " + varType.name() + " with id " + varType.getId()));
                            VariableClusterj.VariableDTO vd = session.newInstance(VariableClusterj.VariableDTO.class);
                            vd.setId(varType.getId());
                            byte[] value = varType.getDefaultValue();
                            vd.setValue(varType.getDefaultValue());
                            session.savePersistent(vd);
                        }
                        session.currentTransaction().commit();
                        continue;
                    }
                    if (e == StorageIdMapDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_storage_id_map");
                        continue;
                    }
                    if (e == BlockLookUpDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_block_lookup_table");
                        continue;
                    }
                    if (e == SafeBlocksDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_safe_blocks");
                        continue;
                    }
                    if (e == MisReplicatedRangeQueueDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_misreplicated_range_queue");
                        continue;
                    }
                    if (e == QuotaUpdateDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_quota_update");
                        continue;
                    }
                    if (e == EncodingStatusDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_encoding_status");
                        continue;
                    }
                    if (e == BlockChecksumDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_block_checksum");
                        continue;
                    }
                    if (e == MetadataLogDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_metadata_log");
                        MysqlServerConnector.truncateTable(transactional, "hdfs_inode_dataset_lookup");
                        continue;
                    }
                    if (e == EncodingJobsDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_encoding_jobs");
                        continue;
                    }
                    if (e == RepairJobsDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_repair_jobs");
                        continue;
                    }
                    if (e == UserDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_users");
                        continue;
                    }
                    if (e == GroupDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_groups");
                        continue;
                    }
                    if (e == UserGroupDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "hdfs_users_groups");
                        continue;
                    }
                    if (e == YarnLeDescriptorDataAccess.class) {
                        MysqlServerConnector.truncateTable(transactional, "yarn_le_descriptors");
                        continue;
                    }
                    if (e == ContainerIdToCleanDataAccess.class) {
                        this.truncate(transactional, "yarn_containerid_toclean");
                        continue;
                    }
                    if (e == ContainerToSignalDataAccess.class) {
                        this.truncate(transactional, "yarn_container_to_signal");
                        continue;
                    }
                    if (e == ContainerToDecreaseDataAccess.class) {
                        this.truncate(transactional, "yarn_container_to_decrease");
                        continue;
                    }
                    if (e == ApplicationAttemptStateDataAccess.class) {
                        this.truncate(transactional, "yarn_applicationattemptstate");
                        continue;
                    }
                    if (e == ApplicationStateDataAccess.class) {
                        this.truncate(transactional, "yarn_applicationstate");
                        continue;
                    }
                    if (e == DelegationKeyDataAccess.class) {
                        this.truncate(transactional, "yarn_delegation_key");
                        continue;
                    }
                    if (e == DelegationTokenDataAccess.class) {
                        this.truncate(transactional, "yarn_delegation_token");
                        continue;
                    }
                    if (e == ContainerStatusDataAccess.class) {
                        this.truncate(transactional, "yarn_containerstatus");
                        continue;
                    }
                    if (e == ResourceDataAccess.class) {
                        this.truncate(transactional, "yarn_resource");
                        continue;
                    }
                    if (e == RMNodeDataAccess.class) {
                        this.truncate(true, "yarn_rmnode");
                        continue;
                    }
                    if (e == RMNodeApplicationsDataAccess.class) {
                        this.truncate(transactional, "yarn_rmnode_applications");
                        continue;
                    }
                    if (e == UpdatedContainerInfoDataAccess.class) {
                        this.truncate(transactional, "yarn_updatedcontainerinfo");
                        continue;
                    }
                    if (e == RMLoadDataAccess.class) {
                        this.truncate(transactional, "yarn_rms_load");
                        continue;
                    }
                    if (e == PendingEventDataAccess.class) {
                        this.truncate(transactional, "yarn_pendingevents");
                        continue;
                    }
                    if (e == NextHeartbeatDataAccess.class) {
                        this.truncate(transactional, "yarn_nextheartbeat");
                        continue;
                    }
                    if (e == ProjectQuotaDataAccess.class) {
                        this.truncate(transactional, "yarn_projects_quota");
                        continue;
                    }
                    if (e == ContainersLogsDataAccess.class) {
                        this.truncate(transactional, "yarn_containers_logs");
                        continue;
                    }
                    if (e == ContainersCheckPointsDataAccess.class) {
                        this.truncate(transactional, "yarn_containers_checkpoint");
                        continue;
                    }
                    if (e == ProjectsDailyCostDataAccess.class) {
                        this.truncate(transactional, "yarn_projects_daily_cost");
                        continue;
                    }
                    if (e == PriceMultiplicatorDataAccess.class) {
                        this.truncate(transactional, "yarn_price_multiplicator");
                        continue;
                    }
                    if (e == HashBucketDataAccess.class) {
                        this.truncate(transactional, "hdfs_hash_buckets");
                        continue;
                    }
                    if (e == ReservationStateDataAccess.class) {
                        this.truncate(transactional, "yarn_reservation_state");
                        continue;
                    }
                    if (e == AceDataAccess.class) {
                        this.truncate(transactional, "hdfs_aces");
                        continue;
                    }
                    if (e == RetryCacheEntryDataAccess.class) {
                        this.truncate(transactional, "hdfs_retry_cache_entry");
                        continue;
                    }
                    if (e == CacheDirectiveDataAccess.class) {
                        this.truncate(transactional, "hdfs_cache_directive");
                        continue;
                    }
                    if (e == CachePoolDataAccess.class) {
                        this.truncate(transactional, "hdfs_cache_pool");
                        continue;
                    }
                    if (e != CachedBlockDataAccess.class) continue;
                    this.truncate(transactional, "hdfs_cached_block");
                }
                MysqlServerConnector.truncateTable(transactional, "hdfs_path_memcached");
                return true;
            }
            catch (SQLException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                continue;
            }
        }
        return false;
    }

    private void truncate(boolean transactional, String tableName) throws StorageException, SQLException {
        MysqlServerConnector.truncateTable(transactional, tableName);
    }

    public void dropAndRecreateDB() throws StorageException {
        MysqlServerConnector.getInstance().dropAndRecreateDB();
    }

    public void flush() throws StorageException {
        DBSession dbSession = sessions.get();
        if (dbSession == null) {
            dbSession = this.dbSessionProvider.getSession();
            sessions.set(dbSession);
        }
        dbSession.getSession().flush();
    }

    public String getClusterConnectString() {
        return this.clusterConnectString;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }
}

