/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.entity.BlockChecksum;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockChecksumClusterj
implements TablesDef.BlockChecksumTableDef,
BlockChecksumDataAccess<BlockChecksum> {
    static final Log LOG = LogFactory.getLog(BlockChecksumClusterj.class);
    private ClusterjConnector clusterjConnector = ClusterjConnector.getInstance();
    private MysqlServerConnector mysqlConnector = MysqlServerConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BlockChecksum blockChecksum) throws StorageException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ADD " + blockChecksum.toString()));
        }
        BlockChecksumDto dto = null;
        HopsSession session = this.clusterjConnector.obtainSession();
        try {
            dto = session.newInstance(BlockChecksumDto.class);
            this.copyState(blockChecksum, dto);
            session.makePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(BlockChecksum blockChecksum) throws StorageException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("UPDATE " + blockChecksum.toString()));
        }
        HopsSession session = this.clusterjConnector.obtainSession();
        BlockChecksumDto dto = null;
        try {
            dto = session.newInstance(BlockChecksumDto.class);
            this.copyState(blockChecksum, dto);
            session.updatePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(BlockChecksum blockChecksum) throws StorageException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DELETE " + blockChecksum.toString()));
        }
        HopsSession session = this.clusterjConnector.obtainSession();
        BlockChecksumDto dto = null;
        try {
            dto = session.newInstance(BlockChecksumDto.class);
            this.copyState(blockChecksum, dto);
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    public BlockChecksum find(int inodeId, int blockIndex) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        BlockChecksumDto dto = session.find(BlockChecksumDto.class, new Object[]{inodeId, blockIndex});
        if (dto == null) {
            return null;
        }
        BlockChecksum bcs = this.createBlockChecksum(dto);
        session.release(dto);
        return bcs;
    }

    public Collection<BlockChecksum> findAll(int inodeId) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<BlockChecksumDto> dobj = qb.createQueryDefinition(BlockChecksumDto.class);
        HopsPredicate pred1 = dobj.get("inodeId").equal(dobj.param("iNodeParam"));
        dobj.where(pred1);
        HopsQuery<BlockChecksumDto> query = session.createQuery(dobj);
        query.setParameter("iNodeParam", inodeId);
        List<BlockChecksumDto> dtos = query.getResultList();
        List<BlockChecksum> csl = this.createBlockChecksumList(dtos);
        session.release(dtos);
        return csl;
    }

    public void deleteAll(int inodeId) throws StorageException {
        String query = String.format("DELETE FROM %s WHERE %s=%d", "hdfs_block_checksum", "inode_id", inodeId);
        try {
            Connection conn = this.mysqlConnector.obtainSession();
            PreparedStatement s = conn.prepareStatement(query);
            s.executeUpdate();
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
        finally {
            this.mysqlConnector.closeSession();
        }
    }

    private void copyState(BlockChecksum blockChecksum, BlockChecksumDto dto) {
        dto.setInodeId(blockChecksum.getInodeId());
        dto.setBlockIndex(blockChecksum.getBlockIndex());
        dto.setChecksum(blockChecksum.getChecksum());
    }

    private List<BlockChecksum> createBlockChecksumList(List<BlockChecksumDto> dtoList) {
        ArrayList<BlockChecksum> list = new ArrayList<BlockChecksum>();
        for (BlockChecksumDto dto : dtoList) {
            list.add(this.createBlockChecksum(dto));
        }
        return list;
    }

    private BlockChecksum createBlockChecksum(BlockChecksumDto dto) {
        if (dto == null) {
            return null;
        }
        return new BlockChecksum(dto.getInodeId(), dto.getBlockIndex(), dto.getChecksum());
    }

    @PersistenceCapable(table="hdfs_block_checksum")
    public static interface BlockChecksumDto {
        @PrimaryKey
        @Column(name="inode_id")
        public int getInodeId();

        public void setInodeId(int var1);

        @PrimaryKey
        @Column(name="block_index")
        public int getBlockIndex();

        public void setBlockIndex(int var1);

        @Column(name="checksum")
        public long getChecksum();

        public void setChecksum(long var1);
    }
}

