/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Ints;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.BlockLookUpDataAccess;
import io.hops.metadata.hdfs.entity.BlockLookUp;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockLookUpClusterj
implements TablesDef.BlockLookUpTableDef,
BlockLookUpDataAccess<BlockLookUp> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private static final int NOT_FOUND_ROW = -1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<BlockLookUp> modified, Collection<BlockLookUp> removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<BlockLookUpDTO> changes = new ArrayList<BlockLookUpDTO>();
        ArrayList<BlockLookUpDTO> deletions = new ArrayList<BlockLookUpDTO>();
        try {
            BlockLookUpDTO bTable;
            for (BlockLookUp block_lookup : removed) {
                bTable = session.newInstance(BlockLookUpDTO.class, block_lookup.getBlockId());
                deletions.add(bTable);
            }
            for (BlockLookUp block_lookup : modified) {
                bTable = session.newInstance(BlockLookUpDTO.class);
                BlockLookUpClusterj.createPersistable(block_lookup, bTable);
                changes.add(bTable);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public BlockLookUp findByBlockId(long blockId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        BlockLookUpDTO lookup = session.find(BlockLookUpDTO.class, blockId);
        if (lookup == null) {
            return null;
        }
        BlockLookUp blu = BlockLookUpClusterj.createBlockInfo(lookup);
        session.release(lookup);
        return blu;
    }

    public int[] findINodeIdsByBlockIds(long[] blockIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        return BlockLookUpClusterj.readINodeIdsByBlockIds(session, blockIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] readINodeIdsByBlockIds(HopsSession session, long[] blockIds) throws StorageException {
        ArrayList<BlockLookUpDTO> bldtos = new ArrayList<BlockLookUpDTO>();
        ArrayList<Integer> inodeIds = new ArrayList<Integer>();
        try {
            for (long blockId : blockIds) {
                BlockLookUpDTO bldto = session.newInstance(BlockLookUpDTO.class, blockId);
                bldto.setINodeId(-1000);
                bldto = session.load(bldto);
                bldtos.add(bldto);
            }
            session.flush();
            for (BlockLookUpDTO bld : bldtos) {
                if (bld.getINodeId() != -1000) {
                    inodeIds.add(bld.getINodeId());
                    continue;
                }
                BlockLookUpDTO bldn = session.find(BlockLookUpDTO.class, bld.getBlockId());
                if (bldn != null) {
                    inodeIds.add(bldn.getINodeId());
                    session.release(bldn);
                    continue;
                }
                inodeIds.add(-1000);
            }
            int[] nArray = Ints.toArray(inodeIds);
            return nArray;
        }
        finally {
            session.release(bldtos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<Long>> getINodeIdsForBlockIds(long[] blockIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<BlockLookUpDTO> bldtos = new ArrayList<BlockLookUpDTO>();
        HashMap<Integer, List<Long>> InodeToBlockIdsMap = new HashMap<Integer, List<Long>>(blockIds.length);
        try {
            for (long blockId : blockIds) {
                BlockLookUpDTO bldto = session.newInstance(BlockLookUpDTO.class, blockId);
                bldto.setINodeId(-1000);
                bldto = session.load(bldto);
                bldtos.add(bldto);
            }
            session.flush();
            Object object = bldtos.iterator();
            while (object.hasNext()) {
                BlockLookUpDTO bld = (BlockLookUpDTO)object.next();
                if (bld.getINodeId() != -1000) {
                    this.addBlockId(InodeToBlockIdsMap, bld);
                    continue;
                }
                BlockLookUpDTO bldn = session.find(BlockLookUpDTO.class, bld.getBlockId());
                if (bldn == null) continue;
                this.addBlockId(InodeToBlockIdsMap, bld);
                session.release(bldn);
            }
            object = InodeToBlockIdsMap;
            return object;
        }
        finally {
            session.release(bldtos);
        }
    }

    private void addBlockId(Map<Integer, List<Long>> map, BlockLookUpDTO bld) {
        List<Long> blockIds = map.get(bld.getINodeId());
        if (blockIds == null) {
            blockIds = new ArrayList<Long>();
            map.put(bld.getINodeId(), blockIds);
        }
        blockIds.add(bld.getBlockId());
    }

    protected static BlockLookUp createBlockInfo(BlockLookUpDTO dto) {
        BlockLookUp lookup = new BlockLookUp(dto.getBlockId(), dto.getINodeId());
        return lookup;
    }

    protected static void createPersistable(BlockLookUp lookup, BlockLookUpDTO persistable) {
        persistable.setBlockId(lookup.getBlockId());
        persistable.setINodeId(lookup.getInodeId());
    }

    @PersistenceCapable(table="hdfs_block_lookup_table")
    public static interface BlockLookUpDTO {
        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @Column(name="inode_id")
        public int getINodeId();

        public void setINodeId(int var1);
    }
}

