/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.NdbBoolean;
import io.hops.metadata.ndb.mysqlserver.CountHelper;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingStatusClusterj
implements TablesDef.EncodingStatusTableDef,
EncodingStatusDataAccess<EncodingStatus> {
    static final Log LOG = LogFactory.getLog(EncodingStatusClusterj.class);
    private ClusterjConnector clusterjConnector = ClusterjConnector.getInstance();
    private MysqlServerConnector mysqlConnector = MysqlServerConnector.getInstance();
    private static final int NOT_FOUND = -1000;
    private static final String STATUS_QUERY = "SELECT * FROM %s WHERE %s=%s ORDER BY %s ASC LIMIT %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EncodingStatus status) throws StorageException {
        LOG.info((Object)("ADD " + status.toString()));
        EncodingStatusDto dto = null;
        HopsSession session = this.clusterjConnector.obtainSession();
        try {
            dto = session.newInstance(EncodingStatusDto.class);
            this.copyState(status, dto);
            session.savePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(EncodingStatus status) throws StorageException {
        LOG.info((Object)("UPDATE " + status.toString()));
        HopsSession session = this.clusterjConnector.obtainSession();
        EncodingStatusDto dto = null;
        try {
            dto = session.newInstance(EncodingStatusDto.class);
            this.copyState(status, dto);
            session.savePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(EncodingStatus status) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        EncodingStatusDto dto = null;
        try {
            dto = session.newInstance(EncodingStatusDto.class);
            this.copyState(status, dto);
            LOG.info((Object)("Delete " + status));
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    private void copyState(EncodingStatus status, EncodingStatusDto dto) {
        Boolean revoked;
        Integer lostParityBlocks;
        Integer lostBlocks;
        String parityFileName;
        Long parityStatusModificationTime;
        EncodingStatus.ParityStatus parityStatus;
        Integer parityInodeId;
        Long statusModificationTime;
        Short targetReplication;
        String codec;
        EncodingStatus.Status sourceStatus;
        Integer inodeId = status.getInodeId();
        if (inodeId != null) {
            dto.setInodeId(inodeId);
        }
        if ((sourceStatus = status.getStatus()) != null) {
            dto.setStatus(sourceStatus.ordinal());
        }
        if ((codec = status.getEncodingPolicy().getCodec()) != null) {
            dto.setCodec(codec);
        }
        if ((targetReplication = Short.valueOf(status.getEncodingPolicy().getTargetReplication())) != null) {
            dto.setTargetReplication(targetReplication);
        }
        if ((statusModificationTime = status.getStatusModificationTime()) != null) {
            dto.setStatusModificationTime(statusModificationTime);
        }
        if ((parityInodeId = status.getParityInodeId()) != null) {
            dto.setParityInodeId(parityInodeId);
        }
        if ((parityStatus = status.getParityStatus()) != null) {
            dto.setParityStatus(parityStatus.ordinal());
        }
        if ((parityStatusModificationTime = status.getParityStatusModificationTime()) != null) {
            dto.setParityStatusModificationTime(parityStatusModificationTime);
        }
        if ((parityFileName = status.getParityFileName()) != null) {
            dto.setParityFileName(parityFileName);
        }
        if ((lostBlocks = status.getLostBlocks()) != null) {
            dto.setLostBlockCount(lostBlocks);
        }
        if ((lostParityBlocks = status.getLostParityBlocks()) != null) {
            dto.setLostParityBlockCount(lostParityBlocks);
        }
        if ((revoked = status.getRevoked()) != null) {
            dto.setRevoked(NdbBoolean.convert(revoked));
        }
    }

    public EncodingStatus findByInodeId(int inodeId) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        EncodingStatusDto dto = session.find(EncodingStatusDto.class, inodeId);
        if (dto == null) {
            return null;
        }
        EncodingStatus es = this.createHopEncoding(dto);
        session.release(dto);
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EncodingStatus> findByInodeIds(Collection<Integer> inodeIds) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        ArrayList<EncodingStatusDto> dtos = new ArrayList<EncodingStatusDto>();
        try {
            List<EncodingStatus> statusList;
            for (int inodeId : inodeIds) {
                EncodingStatusDto dto = session.newInstance(EncodingStatusDto.class, inodeId);
                dto.setStatus(-1000);
                dto = session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            List<EncodingStatus> list = statusList = this.createHopEncodingsIfFound(dtos);
            return list;
        }
        finally {
            session.release(dtos);
        }
    }

    public EncodingStatus findByParityInodeId(int inodeId) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        HopsQueryBuilder builder = session.getQueryBuilder();
        HopsQueryDomainType<EncodingStatusDto> domain = builder.createQueryDefinition(EncodingStatusDto.class);
        domain.where(domain.get("parityInodeId").equal(domain.param("parity_inode_id")));
        HopsQuery<EncodingStatusDto> query = session.createQuery(domain);
        query.setParameter("parity_inode_id", inodeId);
        List<EncodingStatusDto> results = query.getResultList();
        assert (results.size() <= 1);
        if (results.size() == 0) {
            return null;
        }
        EncodingStatus es = this.createHopEncoding(results.get(0));
        session.release(results);
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EncodingStatus> findByParityInodeIds(List<Integer> inodeIds) throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        HopsQueryBuilder builder = session.getQueryBuilder();
        HopsQueryDomainType<EncodingStatusDto> domain = builder.createQueryDefinition(EncodingStatusDto.class);
        domain.where(domain.get("parityInodeId").in(domain.param("parity_inode_id")));
        HopsQuery<EncodingStatusDto> query = session.createQuery(domain);
        query.setParameter("parity_inode_id", inodeIds);
        List<EncodingStatusDto> results = null;
        try {
            results = query.getResultList();
            if (results.size() == 0) {
                Collection<EncodingStatus> collection = null;
                return collection;
            }
            List<EncodingStatus> es = this.createHopEncodings(results);
            session.release(results);
            List<EncodingStatus> list = es;
            return list;
        }
        finally {
            session.release(results);
        }
    }

    public Collection<EncodingStatus> findRequestedEncodings(int limit) throws StorageException {
        List<EncodingStatus> normalEncodings = this.findWithStatus(EncodingStatus.Status.ENCODING_REQUESTED.ordinal(), limit);
        List<EncodingStatus> copyEncodings = this.findWithStatus(EncodingStatus.Status.COPY_ENCODING_REQUESTED.ordinal(), limit);
        ArrayList<EncodingStatus> requests = new ArrayList<EncodingStatus>(limit);
        requests.addAll(normalEncodings);
        requests.addAll(copyEncodings);
        Collections.sort(requests, new Comparator<EncodingStatus>(){

            @Override
            public int compare(EncodingStatus o1, EncodingStatus o2) {
                return o1.getStatusModificationTime().compareTo(o2.getStatusModificationTime());
            }
        });
        return requests.subList(0, requests.size() < limit ? requests.size() : limit);
    }

    public int countRequestedEncodings() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "status=" + EncodingStatus.Status.ENCODING_REQUESTED.ordinal());
    }

    public Collection<EncodingStatus> findRequestedRepairs(int limit) throws StorageException {
        String query = "SELECT inode_id, status, codec, target_replication, parity_status, status_modification_time, parity_status_modification_time, parity_inode_id, parity_file_name, lost_blocks, lost_parity_blocks, lost_blocks+lost_parity_blocks AS lost_block_sum, revoked FROM hdfs_encoding_status WHERE status=" + EncodingStatus.Status.REPAIR_REQUESTED.ordinal() + " ORDER BY " + "lost_block_sum" + " DESC, " + "lost_blocks" + " DESC, " + "status_modification_time" + " ASC LIMIT " + limit;
        return this.find(query);
    }

    public int countRequestedRepairs() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "status=" + EncodingStatus.Status.REPAIR_REQUESTED.ordinal());
    }

    public Collection<EncodingStatus> findActiveEncodings() throws StorageException {
        return this.findAllWithStatus(EncodingStatus.Status.ENCODING_ACTIVE.ordinal());
    }

    public int countActiveEncodings() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "status=" + EncodingStatus.Status.ENCODING_ACTIVE.ordinal());
    }

    public Collection<EncodingStatus> findEncoded(int limit) throws StorageException {
        return this.findWithStatus(EncodingStatus.Status.ENCODED.ordinal(), limit);
    }

    public int countEncoded() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "status=" + EncodingStatus.Status.ENCODED.ordinal());
    }

    public Collection<EncodingStatus> findActiveRepairs() throws StorageException {
        return this.findAllWithStatus(EncodingStatus.Status.REPAIR_ACTIVE.ordinal());
    }

    public int countActiveRepairs() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "status=" + EncodingStatus.Status.REPAIR_ACTIVE.ordinal());
    }

    public Collection<EncodingStatus> findRequestedParityRepairs(int limit) throws StorageException {
        String queryString = "SELECT * FROM %s WHERE %s=%s AND %s!=%s AND %s!=%s ORDER BY %s ASC LIMIT %s";
        String query = String.format(STATUS_QUERY, "hdfs_encoding_status", "parity_status", EncodingStatus.ParityStatus.REPAIR_REQUESTED.ordinal(), "status", EncodingStatus.Status.REPAIR_ACTIVE.ordinal(), "status", EncodingStatus.Status.REPAIR_FAILED.ordinal(), "parity_status_modification_time", limit);
        return this.find(query);
    }

    public int countRequestedParityRepairs() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "parity_status=" + EncodingStatus.ParityStatus.REPAIR_REQUESTED.ordinal());
    }

    public Collection<EncodingStatus> findActiveParityRepairs() throws StorageException {
        return this.findAllWithParityStatus(EncodingStatus.ParityStatus.REPAIR_ACTIVE.ordinal());
    }

    public int countActiveParityRepairs() throws StorageException {
        return CountHelper.countWhere("hdfs_encoding_status", "parity_status=" + EncodingStatus.ParityStatus.REPAIR_ACTIVE.ordinal());
    }

    public void setLostBlockCount(int n) {
    }

    public int getLostBlockCount() {
        return 0;
    }

    public void setLostParityBlockCount(int n) {
    }

    public int getLostParityBlockCount() {
        return 0;
    }

    public Collection<EncodingStatus> findDeleted(int limit) throws StorageException {
        return this.findWithStatus(EncodingStatus.Status.DELETED.ordinal(), limit);
    }

    public Collection<EncodingStatus> findRevoked() throws StorageException {
        HopsSession session = this.clusterjConnector.obtainSession();
        HopsQueryBuilder builder = session.getQueryBuilder();
        HopsQueryDomainType<EncodingStatusDto> domain = builder.createQueryDefinition(EncodingStatusDto.class);
        domain.where(domain.get("revoked").equal(domain.param("revoked")));
        HopsQuery<EncodingStatusDto> query = session.createQuery(domain);
        query.setParameter("revoked", NdbBoolean.convert(true));
        List<EncodingStatusDto> results = query.getResultList();
        List<EncodingStatus> esl = this.createHopEncodings(results);
        session.release(results);
        return esl;
    }

    private List<EncodingStatus> createHopEncodings(List<EncodingStatusDto> list) {
        ArrayList<EncodingStatus> result = new ArrayList<EncodingStatus>(list.size());
        for (EncodingStatusDto dto : list) {
            result.add(this.createHopEncoding(dto));
        }
        return result;
    }

    private List<EncodingStatus> createHopEncodingsIfFound(List<EncodingStatusDto> list) {
        ArrayList<EncodingStatus> result = new ArrayList<EncodingStatus>(list.size());
        for (EncodingStatusDto dto : list) {
            if (dto.getStatus() == -1000) continue;
            result.add(this.createHopEncoding(dto));
        }
        return result;
    }

    private EncodingStatus createHopEncoding(EncodingStatusDto dto) {
        if (dto == null) {
            return null;
        }
        Integer parityInodeId = null;
        if (dto.getParityInodeId() != 0) {
            parityInodeId = dto.getParityInodeId();
        }
        EncodingPolicy policy = new EncodingPolicy(dto.getCodec(), dto.getTargetReplication().shortValue());
        EncodingStatus.Status status = dto.getStatus() == null ? null : EncodingStatus.Status.values()[dto.getStatus()];
        EncodingStatus.ParityStatus parityStatus = dto.getParityStatus() == null ? null : EncodingStatus.ParityStatus.values()[dto.getParityStatus()];
        return new EncodingStatus(Integer.valueOf(dto.getInodeId()), parityInodeId, status, parityStatus, policy, dto.getStatusModificationTime(), dto.getParityStatusModificationTime(), dto.getParityFileName(), Integer.valueOf(dto.getLostBlockCount()), Integer.valueOf(dto.getLostParityBlockCount()), Boolean.valueOf(NdbBoolean.convert(dto.getRevoked())));
    }

    private List<EncodingStatus> findAllWithStatus(int status) throws StorageException {
        return this.findWithStatus(status, Long.MAX_VALUE);
    }

    private List<EncodingStatus> findAllWithParityStatus(int status) throws StorageException {
        return this.findWithParityStatus(status, Long.MAX_VALUE);
    }

    private List<EncodingStatus> findWithParityStatus(int findStatus, long limit) throws StorageException {
        String query = String.format(STATUS_QUERY, "hdfs_encoding_status", "parity_status", findStatus, "parity_status_modification_time", limit);
        return this.find(query);
    }

    private List<EncodingStatus> findWithStatus(int findStatus, long limit) throws StorageException {
        String query = String.format(STATUS_QUERY, "hdfs_encoding_status", "status", findStatus, "status_modification_time", limit);
        return this.find(query);
    }

    private List<EncodingStatus> find(String query) throws StorageException {
        ArrayList<EncodingStatus> resultList;
        try {
            Connection conn = this.mysqlConnector.obtainSession();
            PreparedStatement s = conn.prepareStatement(query);
            ResultSet result = s.executeQuery();
            resultList = new ArrayList<EncodingStatus>();
            while (result.next()) {
                Integer inodeId = result.getInt("inode_id");
                Integer parityInodeId = result.getInt("parity_inode_id");
                Integer status = result.getInt("status");
                String codec = result.getString("codec");
                Short targetReplication = result.getShort("target_replication");
                Long statusModificationTime = result.getLong("status_modification_time");
                Integer parityStatus = result.getInt("parity_status");
                Long parityStatusModificationTime = result.getLong("parity_status_modification_time");
                String parityFileName = result.getString("parity_file_name");
                int lostBlocks = result.getInt("lost_blocks");
                int lostParityBlocks = result.getInt("lost_parity_blocks");
                Boolean revoked = NdbBoolean.convert(result.getByte("revoked"));
                EncodingPolicy policy = new EncodingPolicy(codec, targetReplication.shortValue());
                resultList.add(new EncodingStatus(inodeId, parityInodeId, EncodingStatus.Status.values()[status], EncodingStatus.ParityStatus.values()[parityStatus], policy, statusModificationTime, parityStatusModificationTime, parityFileName, Integer.valueOf(lostBlocks), Integer.valueOf(lostParityBlocks), revoked));
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
        finally {
            this.mysqlConnector.closeSession();
        }
        return resultList;
    }

    @PersistenceCapable(table="hdfs_encoding_status")
    public static interface EncodingStatusDto {
        @PrimaryKey
        @Column(name="inode_id")
        public int getInodeId();

        public void setInodeId(int var1);

        @Column(name="status")
        public Integer getStatus();

        public void setStatus(Integer var1);

        @Column(name="codec")
        public String getCodec();

        public void setCodec(String var1);

        @Column(name="target_replication")
        public Short getTargetReplication();

        public void setTargetReplication(Short var1);

        @Column(name="status_modification_time")
        public Long getStatusModificationTime();

        public void setStatusModificationTime(Long var1);

        @Index
        @Column(name="parity_inode_id")
        public int getParityInodeId();

        public void setParityInodeId(int var1);

        @Column(name="parity_status")
        public Integer getParityStatus();

        public void setParityStatus(Integer var1);

        @Column(name="parity_status_modification_time")
        public Long getParityStatusModificationTime();

        public void setParityStatusModificationTime(Long var1);

        @Column(name="parity_file_name")
        public String getParityFileName();

        public void setParityFileName(String var1);

        @Column(name="lost_blocks")
        public int getLostBlockCount();

        public void setLostBlockCount(int var1);

        @Column(name="lost_parity_blocks")
        public int getLostParityBlockCount();

        public void setLostParityBlockCount(int var1);

        @Column(name="revoked")
        public byte getRevoked();

        public void setRevoked(byte var1);
    }
}

