/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Ints;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.entity.InvalidatedBlock;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvalidatedBlockClusterj
implements TablesDef.InvalidatedBlockTableDef,
InvalidateBlockDataAccess<InvalidatedBlock> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private static final int NOT_FOUND_ROW = -1000;

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_invalidated_blocks");
    }

    public List<InvalidatedBlock> findAllInvalidatedBlocks() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        List<InvalidateBlocksDTO> dtos = session.createQuery(qdt).getResultList();
        List<InvalidatedBlock> ivl = this.createList(dtos);
        session.release(dtos);
        return ivl;
    }

    public List<InvalidatedBlock> findInvalidatedBlockByStorageId(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        qdt.where(qdt.get("storageId").equal(qdt.param("param")));
        HopsQuery<InvalidateBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("param", storageId);
        List<InvalidateBlocksDTO> dtos = query.getResultList();
        List<InvalidatedBlock> ivl = this.createList(dtos);
        session.release(dtos);
        return ivl;
    }

    public Map<Long, Long> findInvalidatedBlockBySidUsingMySQLServer(int storageId) throws StorageException {
        return MySQLQueryHelper.execute(String.format("SELECT %s, %s FROM %s WHERE %s='%d'", "block_id", "generation_stamp", "hdfs_invalidated_blocks", "storage_id", storageId), new MySQLQueryHelper.ResultSetHandler<Map<Long, Long>>(){

            @Override
            public Map<Long, Long> handle(ResultSet result) throws SQLException {
                HashMap<Long, Long> blockInodeMap = new HashMap<Long, Long>();
                while (result.next()) {
                    blockInodeMap.put(result.getLong("block_id"), result.getLong("generation_stamp"));
                }
                return blockInodeMap;
            }
        });
    }

    public List<InvalidatedBlock> findInvalidatedBlocksByBlockId(long bid, int inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        HopsPredicate pred1 = qdt.get("blockId").equal(qdt.param("blockIdParam"));
        HopsPredicate pred2 = qdt.get("iNodeId").equal(qdt.param("iNodeIdParam"));
        qdt.where(pred1.and(pred2));
        HopsQuery<InvalidateBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("blockIdParam", bid);
        query.setParameter("iNodeIdParam", inodeId);
        List<InvalidateBlocksDTO> dtos = query.getResultList();
        List<InvalidatedBlock> ivl = this.createList(dtos);
        session.release(dtos);
        return ivl;
    }

    public List<InvalidatedBlock> findInvalidatedBlocksByINodeId(int inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").equal(qdt.param("iNodeIdParam"));
        qdt.where(pred1);
        HopsQuery<InvalidateBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("iNodeIdParam", inodeId);
        List<InvalidateBlocksDTO> dtos = query.getResultList();
        List<InvalidatedBlock> ivl = this.createList(dtos);
        session.release(dtos);
        return ivl;
    }

    public List<InvalidatedBlock> findInvalidatedBlocksByINodeIds(int[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").in(qdt.param("iNodeIdParam"));
        qdt.where(pred1);
        HopsQuery<InvalidateBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("iNodeIdParam", Ints.asList((int[])inodeIds));
        List<InvalidateBlocksDTO> dtos = query.getResultList();
        List<InvalidatedBlock> ivl = this.createList(dtos);
        session.release(dtos);
        return ivl;
    }

    public InvalidatedBlock findInvBlockByPkey(long blockId, int storageId, int inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{inodeId, blockId, storageId};
        InvalidateBlocksDTO invTable = session.find(InvalidateBlocksDTO.class, pk);
        if (invTable == null) {
            return null;
        }
        InvalidatedBlock ivb = this.createReplica(invTable);
        session.release(invTable);
        return ivb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InvalidatedBlock> findInvalidatedBlocksbyPKS(long[] blockIds, int[] inodesIds, int[] storageIds) throws StorageException {
        int currentTableSize = this.countAll();
        if (currentTableSize == 0) {
            return new ArrayList<InvalidatedBlock>();
        }
        if (currentTableSize < inodesIds.length) {
            return this.findAllInvalidatedBlocks();
        }
        ArrayList<InvalidateBlocksDTO> invBlocks = new ArrayList<InvalidateBlocksDTO>();
        HopsSession session = this.connector.obtainSession();
        try {
            List<InvalidatedBlock> ivbl;
            for (int i = 0; i < blockIds.length; ++i) {
                InvalidateBlocksDTO invTable = session.newInstance(InvalidateBlocksDTO.class, new Object[]{inodesIds[i], blockIds[i], storageIds[i]});
                invTable.setGenerationStamp(-1000L);
                invTable = session.load(invTable);
                invBlocks.add(invTable);
            }
            session.flush();
            List<InvalidatedBlock> list = ivbl = this.createList(invBlocks);
            return list;
        }
        finally {
            session.release(invBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<InvalidatedBlock> removed, Collection<InvalidatedBlock> newed, Collection<InvalidatedBlock> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<InvalidateBlocksDTO> changes = new ArrayList<InvalidateBlocksDTO>();
        ArrayList<InvalidateBlocksDTO> deletions = new ArrayList<InvalidateBlocksDTO>();
        try {
            InvalidateBlocksDTO newInstance;
            for (InvalidatedBlock invBlock : newed) {
                newInstance = session.newInstance(InvalidateBlocksDTO.class);
                this.createPersistable(invBlock, newInstance);
                changes.add(newInstance);
            }
            for (InvalidatedBlock invBlock : removed) {
                newInstance = session.newInstance(InvalidateBlocksDTO.class);
                this.createPersistable(invBlock, newInstance);
                deletions.add(newInstance);
            }
            if (!modified.isEmpty()) {
                throw new UnsupportedOperationException("Not yet Implemented");
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(InvalidateBlocksDTO.class);
    }

    public void removeAllByStorageId(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        qdt.where(qdt.get("storageId").equal(qdt.param("param")));
        HopsQuery<InvalidateBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("param", storageId);
        query.deletePersistentAll();
    }

    private List<InvalidatedBlock> createList(List<InvalidateBlocksDTO> dtoList) {
        ArrayList<InvalidatedBlock> list = new ArrayList<InvalidatedBlock>();
        for (InvalidateBlocksDTO dto : dtoList) {
            if (dto.getGenerationStamp() == -1000L) continue;
            list.add(this.createReplica(dto));
        }
        return list;
    }

    private InvalidatedBlock createReplica(InvalidateBlocksDTO invBlockTable) {
        return new InvalidatedBlock(invBlockTable.getStorageId(), invBlockTable.getBlockId(), invBlockTable.getGenerationStamp(), invBlockTable.getNumBytes(), invBlockTable.getINodeId());
    }

    private void createPersistable(InvalidatedBlock invBlock, InvalidateBlocksDTO newInvTable) {
        newInvTable.setBlockId(invBlock.getBlockId());
        newInvTable.setStorageId(invBlock.getStorageId());
        newInvTable.setGenerationStamp(invBlock.getGenerationStamp());
        newInvTable.setNumBytes(invBlock.getNumBytes());
        newInvTable.setINodeId(invBlock.getInodeId());
    }

    public void removeByBlockIdAndStorageId(long blockId, int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InvalidateBlocksDTO> qdt = qb.createQueryDefinition(InvalidateBlocksDTO.class);
        HopsPredicate pred1 = qdt.get("blockId").equal(qdt.param("blockId"));
        HopsPredicate pred2 = qdt.get("storageId").equal(qdt.param("storageId"));
        qdt.where(pred1.and(pred2));
        HopsQuery<InvalidateBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("blockId", blockId);
        query.setParameter("storageId", storageId);
        query.deletePersistentAll();
    }

    @PersistenceCapable(table="hdfs_invalidated_blocks")
    @PartitionKey(column="inode_id")
    @Index(name="storage_idx")
    public static interface InvalidateBlocksDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public int getINodeId();

        public void setINodeId(int var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @Column(name="generation_stamp")
        public long getGenerationStamp();

        public void setGenerationStamp(long var1);

        @Column(name="num_bytes")
        public long getNumBytes();

        public void setNumBytes(long var1);
    }
}

