/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetadataLogClusterj
implements TablesDef.MetadataLogTableDef,
MetadataLogDataAccess<MetadataLogEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<MetadataLogEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<MetadataLogEntryDto> added = new ArrayList<MetadataLogEntryDto>(logEntries.size());
        ArrayList<DatasetINodeLookupDTO> newLookupDTOS = new ArrayList<DatasetINodeLookupDTO>(logEntries.size());
        try {
            for (MetadataLogEntry logEntry : logEntries) {
                added.add(this.createPersistable(logEntry));
                DatasetINodeLookupDTO lookupDTO = this.createLookupPersistable(logEntry);
                if (logEntry.getOperation() == MetadataLogEntry.Operation.ADD) {
                    newLookupDTOS.add(lookupDTO);
                    continue;
                }
                if (logEntry.getOperation() != MetadataLogEntry.Operation.DELETE) continue;
                session.deletePersistent(lookupDTO);
                session.release(lookupDTO);
            }
            session.makePersistentAll(added);
            session.savePersistentAll(newLookupDTOS);
        }
        finally {
            session.release(added);
            session.release(newLookupDTOS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MetadataLogEntry metadataLogEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        MetadataLogEntryDto dto = null;
        DatasetINodeLookupDTO lookupDTO = null;
        try {
            dto = this.createPersistable(metadataLogEntry);
            lookupDTO = this.createLookupPersistable(metadataLogEntry);
            session.makePersistent(dto);
            if (metadataLogEntry.getOperation() == MetadataLogEntry.Operation.ADD) {
                session.savePersistent(lookupDTO);
            } else if (metadataLogEntry.getOperation() == MetadataLogEntry.Operation.DELETE) {
                session.deletePersistent(lookupDTO);
            }
        }
        finally {
            session.release(dto);
            session.release(lookupDTO);
        }
    }

    private MetadataLogEntryDto createPersistable(MetadataLogEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        MetadataLogEntryDto dto = session.newInstance(MetadataLogEntryDto.class);
        dto.setDatasetId(logEntry.getDatasetId());
        dto.setInodeId(logEntry.getInodeId());
        dto.setInodePartitionId(logEntry.getInodePartitionId());
        dto.setInodeParentId(logEntry.getInodeParentId());
        dto.setInodeName(logEntry.getInodeName());
        dto.setLogicalTime(logEntry.getLogicalTime());
        dto.setOperation(logEntry.getOperationOrdinal());
        return dto;
    }

    private DatasetINodeLookupDTO createLookupPersistable(MetadataLogEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        DatasetINodeLookupDTO dto = session.newInstance(DatasetINodeLookupDTO.class);
        dto.setDatasetId(logEntry.getDatasetId());
        dto.setInodeId(logEntry.getInodeId());
        return dto;
    }

    public Collection<MetadataLogEntry> find(int fileId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<MetadataLogEntryDto> dobj = qb.createQueryDefinition(MetadataLogEntryDto.class);
        HopsPredicate pred1 = dobj.get("inodeId").equal(dobj.param("inodeIdParam"));
        dobj.where(pred1);
        HopsQuery<MetadataLogEntryDto> query = session.createQuery(dobj);
        query.setParameter("inodeIdParam", fileId);
        List<MetadataLogEntryDto> dtos = query.getResultList();
        Collection<MetadataLogEntry> mlel = this.createCollection(dtos);
        session.release(dtos);
        return mlel;
    }

    private Collection<MetadataLogEntry> createCollection(Collection<MetadataLogEntryDto> collection) {
        ArrayList<MetadataLogEntry> list = new ArrayList<MetadataLogEntry>(collection.size());
        for (MetadataLogEntryDto dto : collection) {
            list.add(this.createMetadataLogEntry(dto));
        }
        return list;
    }

    private MetadataLogEntry createMetadataLogEntry(MetadataLogEntryDto dto) {
        return new MetadataLogEntry(dto.getDatasetId(), dto.getInodeId(), dto.getInodePartitionId(), dto.getInodeParentId(), dto.getInodeName(), dto.getLogicalTime(), MetadataLogEntry.Operation.values()[dto.getOperation()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MetadataLogEntry> readExisting(Collection<MetadataLogEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<MetadataLogEntryDto> dtos = new ArrayList<MetadataLogEntryDto>();
        try {
            Collection<MetadataLogEntry> mlel;
            for (MetadataLogEntry logEntry : logEntries) {
                Object[] pk = new Object[]{logEntry.getDatasetId(), logEntry.getInodeId(), logEntry.getLogicalTime()};
                MetadataLogEntryDto dto = session.newInstance(MetadataLogEntryDto.class, pk);
                dto = session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            Collection<MetadataLogEntry> collection = mlel = this.createCollection(dtos);
            return collection;
        }
        finally {
            session.release(dtos);
        }
    }

    @PersistenceCapable(table="hdfs_inode_dataset_lookup")
    public static interface DatasetINodeLookupDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public int getInodeId();

        public void setInodeId(int var1);

        @Column(name="dataset_id")
        public int getDatasetId();

        public void setDatasetId(int var1);
    }

    @PersistenceCapable(table="hdfs_metadata_log")
    public static interface MetadataLogEntryDto {
        @PrimaryKey
        @Column(name="dataset_id")
        public int getDatasetId();

        public void setDatasetId(int var1);

        @PrimaryKey
        @Column(name="inode_id")
        public int getInodeId();

        public void setInodeId(int var1);

        @PrimaryKey
        @Column(name="logical_time")
        public int getLogicalTime();

        public void setLogicalTime(int var1);

        @Column(name="inode_partition_id")
        public int getInodePartitionId();

        public void setInodePartitionId(int var1);

        @Column(name="inode_parent_id")
        public int getInodeParentId();

        public void setInodeParentId(int var1);

        @Column(name="inode_name")
        public String getInodeName();

        public void setInodeName(String var1);

        @Column(name="operation")
        public short getOperation();

        public void setOperation(short var1);
    }
}

