/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReplicaClusterj
implements TablesDef.ReplicaTableDef,
ReplicaDataAccess<Replica> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<Replica> findReplicasById(long blockId, int inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("blockId").equal(dobj.param("blockIdParam"));
        HopsPredicate pred2 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("blockIdParam", blockId);
        query.setParameter("iNodeIdParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<Replica> findReplicasByINodeId(int inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeIdParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<Replica> findReplicasByINodeIds(int[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").in(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeIdParam", Ints.asList((int[])inodeIds));
        return this.convertAndRelease(session, query.getResultList());
    }

    public Map<Long, Integer> findBlockAndInodeIdsByStorageId(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<ReplicaDTO> res = ReplicaClusterj.getReplicas(session, storageId);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (ReplicaDTO dto : res) {
            map.put(dto.getBlockId(), dto.getINodeId());
        }
        session.release(res);
        return map;
    }

    public Map<Long, Integer> findBlockAndInodeIdsByStorageIdAndBucketId(int storageId, int bucketId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("storageId").equal(dobj.param("storageIdParam"));
        HopsPredicate pred2 = dobj.get("hashBucket").equal(dobj.param("bucketIdParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("storageIdParam", storageId);
        query.setParameter("bucketIdParam", bucketId);
        List<Replica> replicas = this.convertAndRelease(session, query.getResultList());
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        for (Replica replica : replicas) {
            result.put(replica.getBlockId(), replica.getInodeId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<Replica> removed, Collection<Replica> newed, Collection<Replica> modified) throws StorageException {
        ArrayList<ReplicaDTO> changes = new ArrayList<ReplicaDTO>();
        ArrayList<ReplicaDTO> deletions = new ArrayList<ReplicaDTO>();
        HopsSession session = this.connector.obtainSession();
        try {
            ReplicaDTO newInstance;
            for (Replica replica : removed) {
                newInstance = session.newInstance(ReplicaDTO.class);
                this.createPersistable(replica, newInstance);
                deletions.add(newInstance);
            }
            for (Replica replica : newed) {
                newInstance = session.newInstance(ReplicaDTO.class);
                this.createPersistable(replica, newInstance);
                changes.add(newInstance);
            }
            for (Replica replica : modified) {
                newInstance = session.newInstance(ReplicaDTO.class);
                this.createPersistable(replica, newInstance);
                changes.add(newInstance);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public Map<Long, Integer> findBlockAndInodeIdsByStorageIdAndBucketIds(int sId, List<Integer> mismatchedBuckets) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("storageId").equal(dobj.param("storageIdParam"));
        if (mismatchedBuckets.size() > 0) {
            int first = mismatchedBuckets.get(0);
            HopsPredicate pred2 = dobj.get("hashBucket").equal(dobj.param("bucketIdParam" + first));
            for (int i = 1; i < mismatchedBuckets.size(); ++i) {
                int next = mismatchedBuckets.get(i);
                pred2 = pred2.or(dobj.get("hashBucket").equal(dobj.param("bucketIdParam" + next)));
            }
            dobj.where(pred1.and(pred2));
            HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
            query.setParameter("storageIdParam", sId);
            for (int mismatchedBucket : mismatchedBuckets) {
                query.setParameter("bucketIdParam" + mismatchedBucket, mismatchedBucket);
            }
            List<Replica> replicas = this.convertAndRelease(session, query.getResultList());
            HashMap<Long, Integer> results = new HashMap<Long, Integer>();
            for (Replica replica : replicas) {
                results.put(replica.getBlockId(), replica.getInodeId());
            }
            return results;
        }
        return new HashMap<Long, Integer>();
    }

    public int countAllReplicasForStorageId(int sid) throws StorageException {
        return MySQLQueryHelper.countWithCriterion("hdfs_replicas", String.format("%s=%d", "storage_id", sid));
    }

    protected static Set<Long> getReplicas(int storageId) throws StorageException {
        return MySQLQueryHelper.execute(String.format("SELECT %s FROM %s WHERE %s='%d'", "block_id", "hdfs_replicas", "storage_id", storageId), new MySQLQueryHelper.ResultSetHandler<Set<Long>>(){

            @Override
            public Set<Long> handle(ResultSet result) throws SQLException {
                HashSet blocks = Sets.newHashSet();
                while (result.next()) {
                    blocks.add(result.getLong("block_id"));
                }
                return blocks;
            }
        });
    }

    protected static List<ReplicaDTO> getReplicas(HopsSession session, int storageId) throws StorageException {
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        dobj.where(dobj.get("storageId").equal(dobj.param("param")));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("param", storageId);
        return query.getResultList();
    }

    private List<Replica> convertAndRelease(HopsSession session, List<ReplicaDTO> triplets) throws StorageException {
        ArrayList<Replica> replicas = new ArrayList<Replica>(triplets.size());
        for (ReplicaDTO t : triplets) {
            replicas.add(new Replica(t.getStorageId(), t.getBlockId(), t.getINodeId(), t.getHashBucket()));
            session.release(t);
        }
        return replicas;
    }

    private void createPersistable(Replica replica, ReplicaDTO newInstance) {
        newInstance.setBlockId(replica.getBlockId());
        newInstance.setStorageId(replica.getStorageId());
        newInstance.setINodeId(replica.getInodeId());
        newInstance.setHashBucket(replica.getBucketId());
    }

    @PersistenceCapable(table="hdfs_replicas")
    @PartitionKey(column="inode_id")
    @Index(name="storage_idx")
    public static interface ReplicaDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public int getINodeId();

        public void setINodeId(int var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @Column(name="bucket_id")
        public int getHashBucket();

        public void setHashBucket(int var1);
    }
}

