/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.INodeAttributesDataAccess;
import io.hops.metadata.hdfs.entity.INodeAttributes;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class INodeAttributesClusterj
implements TablesDef.INodeAttributesTableDef,
INodeAttributesDataAccess<INodeAttributes> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public INodeAttributes findAttributesByPk(Long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        INodeAttributesDTO dto = session.find(INodeAttributesDTO.class, inodeId);
        INodeAttributes iNodeAttributes = null;
        if (dto != null) {
            iNodeAttributes = this.makeINodeAttributes(dto);
            session.release(dto);
        }
        return iNodeAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<INodeAttributes> findAttributesByPkList(List<INodeCandidatePrimaryKey> inodePks) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<INodeAttributes> inodeAttributesBatchResponse = new ArrayList<INodeAttributes>();
        ArrayList<INodeAttributesDTO> inodeAttributesBatchRequest = new ArrayList<INodeAttributesDTO>();
        try {
            for (INodeCandidatePrimaryKey pk : inodePks) {
                INodeAttributesDTO dto = session.newInstance(INodeAttributesDTO.class);
                dto.setId(pk.getInodeId());
                inodeAttributesBatchRequest.add(dto);
                session.load(dto);
            }
            session.flush();
            for (INodeAttributesDTO anInodeAttributesBatchRequest : inodeAttributesBatchRequest) {
                inodeAttributesBatchResponse.add(this.makeINodeAttributes(anInodeAttributesBatchRequest));
            }
            ArrayList<INodeAttributes> arrayList = inodeAttributesBatchResponse;
            return arrayList;
        }
        finally {
            session.release(inodeAttributesBatchRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<INodeAttributes> modified, Collection<INodeAttributes> removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<INodeAttributesDTO> changes = new ArrayList<INodeAttributesDTO>();
        ArrayList<INodeAttributesDTO> deletions = new ArrayList<INodeAttributesDTO>();
        try {
            INodeAttributesDTO persistable;
            if (removed != null) {
                for (INodeAttributes attr : removed) {
                    persistable = session.newInstance(INodeAttributesDTO.class, attr.getInodeId());
                    deletions.add(persistable);
                }
            }
            if (modified != null) {
                for (INodeAttributes attr : modified) {
                    persistable = this.createPersistable(attr, session);
                    changes.add(persistable);
                }
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private INodeAttributesDTO createPersistable(INodeAttributes attribute, HopsSession session) throws StorageException {
        INodeAttributesDTO dto = session.newInstance(INodeAttributesDTO.class);
        dto.setId(attribute.getInodeId());
        dto.setNSQuota(attribute.getNsQuota());
        dto.setNSCount(attribute.getNsCount());
        dto.setDSQuota(attribute.getDsQuota());
        dto.setDiskspace(attribute.getDiskspace());
        return dto;
    }

    private INodeAttributes makeINodeAttributes(INodeAttributesDTO dto) {
        if (dto == null) {
            return null;
        }
        INodeAttributes iNodeAttributes = new INodeAttributes(Long.valueOf(dto.getId()), Long.valueOf(dto.getNSQuota()), Long.valueOf(dto.getNSCount()), Long.valueOf(dto.getDSQuota()), Long.valueOf(dto.getDiskspace()));
        return iNodeAttributes;
    }

    @PersistenceCapable(table="hdfs_inode_attributes")
    public static interface INodeAttributesDTO {
        @PrimaryKey
        @Column(name="inodeId")
        public long getId();

        public void setId(long var1);

        @Column(name="nsquota")
        public long getNSQuota();

        public void setNSQuota(long var1);

        @Column(name="dsquota")
        public long getDSQuota();

        public void setDSQuota(long var1);

        @Column(name="nscount")
        public long getNSCount();

        public void setNSCount(long var1);

        @Column(name="diskspace")
        public long getDiskspace();

        public void setDiskspace(long var1);
    }
}

