/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INode;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.NdbBoolean;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.transaction.context.EntityContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class INodeClusterj
implements TablesDef.INodeTableDef,
INodeDataAccess<INode> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private MysqlServerConnector mysqlConnector = MysqlServerConnector.getInstance();
    private static final int NOT_FOUND_ROW = -1000;

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_inodes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<INode> removed, Collection<INode> newEntries, Collection<INode> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<InodeDTO> changes = new ArrayList<InodeDTO>();
        ArrayList<InodeDTO> deletions = new ArrayList<InodeDTO>();
        try {
            InodeDTO persistable;
            for (INode inode : removed) {
                Object[] pk = new Object[]{inode.getPartitionId(), inode.getParentId(), inode.getName()};
                InodeDTO persistable2 = session.newInstance(InodeDTO.class, pk);
                deletions.add(persistable2);
            }
            for (INode inode : newEntries) {
                persistable = session.newInstance(InodeDTO.class);
                INodeClusterj.createPersistable(inode, persistable);
                changes.add(persistable);
            }
            for (INode inode : modified) {
                persistable = session.newInstance(InodeDTO.class);
                INodeClusterj.createPersistable(inode, persistable);
                changes.add(persistable);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode findInodeByIdFTIS(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
        HopsPredicate pred1 = dobj.get("id").equal(dobj.param("idParam"));
        dobj.where(pred1);
        HopsQuery<InodeDTO> query = session.createQuery(dobj);
        query.setParameter("idParam", inodeId);
        List<InodeDTO> results = null;
        try {
            results = query.getResultList();
            if (results.size() > 1) {
                throw new StorageException("Fetching inode by id:" + inodeId + ". Only one record was expected. Found: " + results.size());
            }
            if (results.size() == 1) {
                INode inode;
                INode iNode = inode = INodeClusterj.convert(results.get(0));
                return iNode;
            }
            INode iNode = null;
            return iNode;
        }
        finally {
            session.release(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<INode> findInodesByIdsFTIS(long[] inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
        HopsPredicate pred1 = dobj.get("id").in(dobj.param("idParam"));
        dobj.where(pred1);
        HopsQuery<InodeDTO> query = session.createQuery(dobj);
        query.setParameter("idParam", Longs.asList((long[])inodeId));
        List<InodeDTO> results = null;
        try {
            results = query.getResultList();
            if (results.isEmpty()) {
                Collection<INode> collection = null;
                return collection;
            }
            List<INode> list = this.convert(results);
            return list;
        }
        finally {
            session.release(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<INode> findInodesByParentIdFTIS(long parentId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
        HopsPredicate pred1 = dobj.get("parentId").equal(dobj.param("parentIDParam"));
        dobj.where(pred1);
        HopsQuery<InodeDTO> query = session.createQuery(dobj);
        query.setParameter("parentIDParam", parentId);
        List<InodeDTO> results = null;
        try {
            List<INode> inodeList;
            results = query.getResultList();
            List<INode> list = inodeList = this.convert(results);
            return list;
        }
        finally {
            session.release(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<INode> findInodesByParentIdAndPartitionIdPPIS(long parentId, long partitionId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
        HopsPredicate pred1 = dobj.get("partitionId").equal(dobj.param("partitionIDParam"));
        HopsPredicate pred2 = dobj.get("parentId").equal(dobj.param("parentIDParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<InodeDTO> query = session.createQuery(dobj);
        query.setParameter("partitionIDParam", partitionId);
        query.setParameter("parentIDParam", parentId);
        List<InodeDTO> results = null;
        try {
            List<INode> inodeList;
            results = query.getResultList();
            List<INode> list = inodeList = this.convert(results);
            return list;
        }
        finally {
            session.release(results);
        }
    }

    public List<ProjectedINode> findInodesFTISTx(long parentId, EntityContext.LockMode lock) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<InodeDTO> results = null;
        try {
            session.currentTransaction().begin();
            session.setLockMode(this.getLock(lock));
            HopsQueryBuilder qb = session.getQueryBuilder();
            HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
            HopsPredicate pred2 = dobj.get("parentId").equal(dobj.param("parentIDParam"));
            dobj.where(pred2);
            HopsQuery<InodeDTO> query = session.createQuery(dobj);
            query.setParameter("parentIDParam", parentId);
            ArrayList<ProjectedINode> resultList = new ArrayList<ProjectedINode>();
            results = query.getResultList();
            for (InodeDTO inode : results) {
                resultList.add(this.createProjectedINode(inode));
            }
            session.currentTransaction().commit();
            ArrayList<ProjectedINode> arrayList = resultList;
            return arrayList;
        }
        catch (StorageException e) {
            session.currentTransaction().rollback();
            throw e;
        }
        finally {
            session.release(results);
        }
    }

    private ProjectedINode createProjectedINode(InodeDTO inode) {
        return new ProjectedINode(inode.getId(), inode.getParentId(), inode.getName(), inode.getPartitionId(), NdbBoolean.convert(inode.getIsDir()), inode.getPermission(), inode.getUserID(), inode.getGroupID(), inode.getHeader(), inode.getSymlink() != null, NdbBoolean.convert(inode.getQuotaEnabled()), NdbBoolean.convert(inode.getUnderConstruction()), NdbBoolean.convert(inode.getSubtreeLocked()), inode.getSubtreeLockOwner(), inode.getSize(), inode.getLogicalTime(), inode.getStoragePolicy(), inode.getNumAces());
    }

    public List<INode> lockInodesUsingPkBatchTx(String[] names, long[] parentIds, long[] partitionIds, EntityContext.LockMode lock) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.currentTransaction().begin();
        session.setLockMode(this.getLock(lock));
        ArrayList<InodeDTO> dtos = new ArrayList<InodeDTO>();
        try {
            for (int i = 0; i < names.length; ++i) {
                InodeDTO dto = session.newInstance(InodeDTO.class, new Object[]{partitionIds[i], parentIds[i], names[i]});
                dto.setId(-1000L);
                dto = session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            List<INode> inodeList = this.convert(dtos);
            session.currentTransaction().commit();
            List<INode> list = inodeList;
            return list;
        }
        catch (StorageException e) {
            session.currentTransaction().rollback();
            throw e;
        }
        finally {
            session.release(dtos);
        }
    }

    public List<ProjectedINode> findInodesPPISTx(long parentId, long partitionId, EntityContext.LockMode lock) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<InodeDTO> results = null;
        try {
            session.currentTransaction().begin();
            session.setLockMode(this.getLock(lock));
            HopsQueryBuilder qb = session.getQueryBuilder();
            HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
            HopsPredicate pred1 = dobj.get("partitionId").equal(dobj.param("partitionIDParam"));
            HopsPredicate pred2 = dobj.get("parentId").equal(dobj.param("parentIDParam"));
            dobj.where(pred1.and(pred2));
            HopsQuery<InodeDTO> query = session.createQuery(dobj);
            query.setParameter("partitionIDParam", partitionId);
            query.setParameter("parentIDParam", parentId);
            ArrayList<ProjectedINode> resultList = new ArrayList<ProjectedINode>();
            results = query.getResultList();
            for (InodeDTO inode : results) {
                resultList.add(this.createProjectedINode(inode));
            }
            session.currentTransaction().commit();
            ArrayList<ProjectedINode> arrayList = resultList;
            return arrayList;
        }
        catch (StorageException e) {
            session.currentTransaction().rollback();
            throw e;
        }
        finally {
            session.release(results);
        }
    }

    public INode findInodeByNameParentIdAndPartitionIdPK(String name, long parentId, long partitionId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{partitionId, parentId, name};
        InodeDTO result = session.find(InodeDTO.class, pk);
        if (result != null) {
            INode inode = INodeClusterj.convert(result);
            session.release(result);
            return inode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<INode> getINodesPkBatched(String[] names, long[] parentIds, long[] partitionIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<InodeDTO> dtos = new ArrayList<InodeDTO>();
        try {
            List<INode> inodeList;
            for (int i = 0; i < names.length; ++i) {
                InodeDTO dto = session.newInstance(InodeDTO.class, new Object[]{partitionIds[i], parentIds[i], names[i]});
                dto.setId(-1000L);
                dto = session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            List<INode> list = inodeList = this.convert(dtos);
            return list;
        }
        finally {
            session.release(dtos);
        }
    }

    private boolean isRoot(INode inode) {
        return inode.getName().equals("") && inode.getParentId() == 0L && inode.getId() == 1L;
    }

    public List<INodeIdentifier> getAllINodeFiles(long startId, long endId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
        HopsPredicate pred = dobj.get("isDir").equal(dobj.param("isDirParam"));
        HopsPredicate pred2 = dobj.get("id").between(dobj.param("startId"), dobj.param("endId"));
        dobj.where(pred.not().and(pred2));
        HopsQuery<InodeDTO> query = session.createQuery(dobj);
        query.setParameter("isDirParam", NdbBoolean.convert(true));
        query.setParameter("startId", startId);
        query.setParameter("endId", endId - 1L);
        List<InodeDTO> dtos = query.getResultList();
        ArrayList<INodeIdentifier> res = new ArrayList<INodeIdentifier>();
        for (InodeDTO dto : dtos) {
            res.add(new INodeIdentifier(Long.valueOf(dto.getId()), Long.valueOf(dto.getParentId()), dto.getName(), Long.valueOf(dto.getPartitionId())));
        }
        session.release(dtos);
        return res;
    }

    public boolean haveFilesWithIdsBetween(long startId, long endId) throws StorageException {
        return MySQLQueryHelper.exists("hdfs_inodes", String.format("%s<>0 and %s between %d and %d", "header", "id", startId, endId - 1L));
    }

    public boolean haveFilesWithIdsGreaterThan(long id) throws StorageException {
        return MySQLQueryHelper.exists("hdfs_inodes", String.format("%s<>0 and %s>%d", "header", "id", id));
    }

    public long getMinFileId() throws StorageException {
        return MySQLQueryHelper.minInt("hdfs_inodes", "id", String.format("%s<>0", "header"));
    }

    public long getMaxFileId() throws StorageException {
        return MySQLQueryHelper.maxInt("hdfs_inodes", "id", String.format("%s<>0", "header"));
    }

    public int countAllFiles() throws StorageException {
        return MySQLQueryHelper.countWithCriterion("hdfs_inodes", String.format("%s<>0", "header"));
    }

    public void deleteInode(String inodeName) throws StorageException {
        String query = "delete from hdfs_inodes where name = \"" + inodeName + "\"";
        MySQLQueryHelper.execute(query);
    }

    public List<INode> allINodes() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<InodeDTO> query = session.createQuery(qb.createQueryDefinition(InodeDTO.class));
        List<InodeDTO> dtos = query.getResultList();
        List<INode> list = this.convert(dtos);
        session.release(dtos);
        return list;
    }

    public boolean hasChildren(long parentId, boolean areChildRandomlyPartitioned) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<InodeDTO> dobj = qb.createQueryDefinition(InodeDTO.class);
        HopsPredicate pred1 = dobj.get("parentId").equal(dobj.param("parentIDParam"));
        HopsPredicate pred2 = dobj.get("partitionId").equal(dobj.param("partitionIDParam"));
        if (areChildRandomlyPartitioned) {
            dobj.where(pred1);
        } else {
            dobj.where(pred2.and(pred1));
        }
        HopsQuery<InodeDTO> query = session.createQuery(dobj);
        query.setParameter("parentIDParam", parentId);
        if (!areChildRandomlyPartitioned) {
            query.setParameter("partitionIDParam", parentId);
        }
        query.setLimits(0L, 1L);
        List<InodeDTO> results = query.getResultList();
        if (results.isEmpty()) {
            return false;
        }
        session.release(results);
        return true;
    }

    public void updateLogicalTime(Collection<MetadataLogEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        for (MetadataLogEntry logEntry : logEntries) {
            InodeDTO inodeDTO = this.createPersistable(session, logEntry);
            session.savePersistent(inodeDTO);
            session.release(inodeDTO);
        }
    }

    public int countSubtreeLockedInodes() throws StorageException {
        String query = "subtree_locked = 1";
        return MySQLQueryHelper.countWithCriterion("hdfs_inodes", query);
    }

    private InodeDTO createPersistable(HopsSession session, MetadataLogEntry logEntry) throws StorageException {
        InodeDTO inodeDTO = session.newInstance(InodeDTO.class);
        inodeDTO.setPartitionId(logEntry.getInodePartitionId());
        inodeDTO.setParentId(logEntry.getInodeParentId());
        inodeDTO.setName(logEntry.getInodeName());
        inodeDTO.setLogicalTime(logEntry.getLogicalTime());
        return inodeDTO;
    }

    private List<INode> convert(List<InodeDTO> list) throws StorageException {
        ArrayList<INode> inodes = new ArrayList<INode>();
        for (InodeDTO persistable : list) {
            if (persistable.getId() == -1000L) continue;
            inodes.add(INodeClusterj.convert(persistable));
        }
        return inodes;
    }

    protected static INode convert(InodeDTO persistable) {
        INode node = new INode(persistable.getId(), persistable.getName(), persistable.getParentId(), persistable.getPartitionId(), NdbBoolean.convert(persistable.getIsDir()), NdbBoolean.convert(persistable.getQuotaEnabled()), persistable.getModificationTime(), persistable.getATime(), persistable.getUserID(), persistable.getGroupID(), persistable.getPermission(), NdbBoolean.convert(persistable.getUnderConstruction()), persistable.getClientName(), persistable.getClientMachine(), persistable.getClientNode(), persistable.getGenerationStamp(), persistable.getHeader(), persistable.getSymlink(), NdbBoolean.convert(persistable.getSubtreeLocked()), persistable.getSubtreeLockOwner(), NdbBoolean.convert(persistable.getMetaEnabled()), persistable.getSize(), NdbBoolean.convert(persistable.getFileStoredInDd()), persistable.getLogicalTime(), persistable.getStoragePolicy(), persistable.getChildrenNum(), persistable.getNumAces());
        return node;
    }

    protected static void createPersistable(INode inode, InodeDTO persistable) {
        persistable.setId(inode.getId());
        persistable.setName(inode.getName());
        persistable.setParentId(inode.getParentId());
        persistable.setQuotaEnabled(NdbBoolean.convert(inode.isDirWithQuota()));
        persistable.setModificationTime(inode.getModificationTime());
        persistable.setATime(inode.getAccessTime());
        persistable.setUserID(inode.getUserID());
        persistable.setGroupID(inode.getGroupID());
        persistable.setPermission(inode.getPermission());
        persistable.setUnderConstruction(NdbBoolean.convert(inode.isUnderConstruction()));
        persistable.setClientName(inode.getClientName());
        persistable.setClientMachine(inode.getClientMachine());
        persistable.setClientNode(inode.getClientNode());
        persistable.setGenerationStamp(inode.getGenerationStamp());
        persistable.setHeader(inode.getHeader());
        persistable.setSymlink(inode.getSymlink());
        persistable.setSubtreeLocked(NdbBoolean.convert(inode.isSubtreeLocked()));
        persistable.setSubtreeLockOwner(inode.getSubtreeLockOwner());
        persistable.setMetaEnabled(NdbBoolean.convert(inode.isMetaEnabled()));
        persistable.setSize(inode.getFileSize());
        persistable.setFileStoredInDd(NdbBoolean.convert(inode.isFileStoredInDB()));
        persistable.setIsDir(NdbBoolean.convert(inode.isDirectory()));
        persistable.setPartitionId(inode.getPartitionId());
        persistable.setLogicalTime(inode.getLogicalTime());
        persistable.setStoragePolicy(inode.getStoragePolicy());
        persistable.setChildrenNum(inode.getChildrenNum());
        persistable.setNumAces(inode.getNumAces());
    }

    private void explain(HopsQuery<InodeDTO> query) {
    }

    LockMode getLock(EntityContext.LockMode lock) {
        switch (lock) {
            case WRITE_LOCK: {
                return LockMode.EXCLUSIVE;
            }
            case READ_LOCK: {
                return LockMode.SHARED;
            }
            case READ_COMMITTED: {
                return LockMode.READ_COMMITTED;
            }
        }
        throw new UnsupportedOperationException("Lock Type is not supported");
    }

    @PersistenceCapable(table="hdfs_inodes")
    @PartitionKey(column="partition_id")
    public static interface InodeDTO {
        @PrimaryKey
        @Column(name="partition_id")
        public long getPartitionId();

        public void setPartitionId(long var1);

        @PrimaryKey
        @Column(name="parent_id")
        @Index(name="pidex")
        public long getParentId();

        public void setParentId(long var1);

        @PrimaryKey
        @Column(name="name")
        public String getName();

        public void setName(String var1);

        @Column(name="id")
        @Index(name="inode_idx")
        public long getId();

        public void setId(long var1);

        @Column(name="is_dir")
        public byte getIsDir();

        public void setIsDir(byte var1);

        @Column(name="modification_time")
        public long getModificationTime();

        public void setModificationTime(long var1);

        @Column(name="access_time")
        public long getATime();

        public void setATime(long var1);

        @Column(name="user_id")
        public int getUserID();

        public void setUserID(int var1);

        @Column(name="group_id")
        public int getGroupID();

        public void setGroupID(int var1);

        @Column(name="permission")
        public short getPermission();

        public void setPermission(short var1);

        @Column(name="client_name")
        public String getClientName();

        public void setClientName(String var1);

        @Column(name="client_machine")
        public String getClientMachine();

        public void setClientMachine(String var1);

        @Column(name="client_node")
        public String getClientNode();

        public void setClientNode(String var1);

        @Column(name="generation_stamp")
        public int getGenerationStamp();

        public void setGenerationStamp(int var1);

        @Column(name="header")
        public long getHeader();

        public void setHeader(long var1);

        @Column(name="symlink")
        public String getSymlink();

        public void setSymlink(String var1);

        @Column(name="quota_enabled")
        public byte getQuotaEnabled();

        public void setQuotaEnabled(byte var1);

        @Column(name="under_construction")
        public byte getUnderConstruction();

        public void setUnderConstruction(byte var1);

        @Column(name="subtree_locked")
        public byte getSubtreeLocked();

        public void setSubtreeLocked(byte var1);

        @Column(name="subtree_lock_owner")
        public long getSubtreeLockOwner();

        public void setSubtreeLockOwner(long var1);

        @Column(name="meta_enabled")
        public byte getMetaEnabled();

        public void setMetaEnabled(byte var1);

        @Column(name="size")
        public long getSize();

        public void setSize(long var1);

        @Column(name="file_stored_in_db")
        public byte getFileStoredInDd();

        public void setFileStoredInDd(byte var1);

        @Column(name="logical_time")
        public int getLogicalTime();

        public void setLogicalTime(int var1);

        @Column(name="storage_policy")
        public byte getStoragePolicy();

        public void setStoragePolicy(byte var1);

        @Column(name="children_num")
        public int getChildrenNum();

        public void setChildrenNum(int var1);

        @Column(name="num_aces")
        public int getNumAces();

        public void setNumAces(int var1);
    }
}

