/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Lists;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.entity.Group;
import io.hops.metadata.hdfs.entity.User;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.hdfs.GroupClusterj;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserGroupClusterj
implements TablesDef.UsersGroupsTableDef,
UserGroupDataAccess<User, Group> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public void addUserToGroup(User user, Group group) throws StorageException {
        this.addUserToGroup(user.getId(), group.getId());
    }

    public void addUserToGroup(int userId, int groupId) throws StorageException {
        this.addUserToGroups(userId, Arrays.asList(groupId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserToGroups(int userId, List<Integer> groupIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList dtos = Lists.newArrayListWithExpectedSize((int)groupIds.size());
        try {
            for (int groupId : groupIds) {
                UserGroupDTO dto = session.newInstance(UserGroupDTO.class);
                dto.setUserId(userId);
                dto.setGroupId(groupId);
                dtos.add(dto);
            }
            session.savePersistentAll(dtos);
        }
        finally {
            session.release(dtos);
        }
    }

    public List<Group> getGroupsForUser(User user) throws StorageException {
        return this.getGroupsForUser(user.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getGroupsForUser(int userId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<UserGroupDTO> userGroupDTOs = null;
        ArrayList groupDTOs = null;
        try {
            HopsQueryBuilder qb = session.getQueryBuilder();
            HopsQueryDomainType<UserGroupDTO> dobj = qb.createQueryDefinition(UserGroupDTO.class);
            dobj.where(dobj.get("userId").equal(dobj.param("param")));
            HopsQuery<UserGroupDTO> query = session.createQuery(dobj);
            query.setParameter("param", userId);
            userGroupDTOs = query.getResultList();
            groupDTOs = Lists.newArrayList();
            for (UserGroupDTO ug : userGroupDTOs) {
                GroupClusterj.GroupDTO groupDTO = session.newInstance(GroupClusterj.GroupDTO.class, ug.getGroupId());
                session.load(groupDTO);
                groupDTOs.add(groupDTO);
            }
            session.flush();
            List<Group> list = GroupClusterj.convert(session, groupDTOs);
            return list;
        }
        finally {
            session.release(userGroupDTOs);
            session.release(groupDTOs);
        }
    }

    @PersistenceCapable(table="hdfs_users_groups")
    public static interface UserGroupDTO {
        @PrimaryKey
        @Column(name="user_id")
        public int getUserId();

        public void setUserId(int var1);

        @PrimaryKey
        @Column(name="group_id")
        public int getGroupId();

        public void setGroupId(int var1);
    }
}

