/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.wrapper;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import io.hops.exception.ForeignKeyConstraintViolationException;
import io.hops.exception.OutOfDBExtentsException;
import io.hops.exception.StorageException;
import io.hops.exception.TransientStorageException;
import io.hops.exception.TupleAlreadyExistedException;
import io.hops.exception.UniqueKeyConstraintViolationException;

public class HopsExceptionHelper {
    public static StorageException wrap(ClusterJException e) {
        if (HopsExceptionHelper.isTransient(e)) {
            return new TransientStorageException((Throwable)e);
        }
        if (HopsExceptionHelper.isTupleAlreadyExisted(e)) {
            return new TupleAlreadyExistedException((Throwable)e);
        }
        if (HopsExceptionHelper.isForeignKeyConstraintViolation(e)) {
            return new ForeignKeyConstraintViolationException((Throwable)e);
        }
        if (HopsExceptionHelper.isUniqueKeyConstraintViolation(e)) {
            return new UniqueKeyConstraintViolationException((Throwable)e);
        }
        if (HopsExceptionHelper.isOutOfDBExtents(e)) {
            return new OutOfDBExtentsException((Throwable)e);
        }
        return new StorageException((Throwable)e);
    }

    private static boolean isTransient(ClusterJException e) {
        if (e instanceof ClusterJDatastoreException) {
            if (e.getMessage().contains("classification 7")) {
                return true;
            }
            if (e.getMessage().contains("classification 8")) {
                return true;
            }
            if (e.getMessage().contains("classification 9")) {
                return true;
            }
            if (e.getMessage().contains("classification 10")) {
                return true;
            }
            if (e.getMessage().contains("classification 15")) {
                return true;
            }
            if (e.getMessage().contains("classification 18")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isTupleAlreadyExisted(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, "code 630");
    }

    private static boolean isForeignKeyConstraintViolation(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, "code 255");
    }

    private static boolean isUniqueKeyConstraintViolation(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, "code 893");
    }

    private static boolean isOutOfDBExtents(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, "code 1601");
    }

    private static boolean isExceptionContains(ClusterJException e, String checkString) {
        return e instanceof ClusterJDatastoreException && e.getMessage().contains(checkString);
    }
}

