/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.CachedBlockDataAccess;
import io.hops.metadata.hdfs.entity.CachedBlock;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedBlockClusterJ
implements TablesDef.CachedBlockTableDef,
CachedBlockDataAccess<CachedBlock> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    protected static Log LOG = LogFactory.getLog(CachedBlockClusterJ.class);

    public CachedBlock find(long blockId, long inodeId, String datanodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{blockId, inodeId, datanodeId};
        CachedBlockDTO result = session.find(CachedBlockDTO.class, pk);
        if (result != null) {
            CachedBlock retryCacheEntry = this.convert(result);
            session.release(result);
            return retryCacheEntry;
        }
        return null;
    }

    public List<CachedBlock> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachedBlockDTO> dobj = qb.createQueryDefinition(CachedBlockDTO.class);
        HopsQuery<CachedBlockDTO> query = session.createQuery(dobj);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<CachedBlock> findCachedBlockById(long blockId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachedBlockDTO> dobj = qb.createQueryDefinition(CachedBlockDTO.class);
        HopsPredicate pred1 = dobj.get("blockId").equal(dobj.param("blockId"));
        HopsQuery<CachedBlockDTO> query = session.createQuery(dobj);
        query.setParameter("blockId", blockId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<CachedBlock> findCachedBlockByINodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachedBlockDTO> dobj = qb.createQueryDefinition(CachedBlockDTO.class);
        HopsPredicate pred1 = dobj.get("inodeId").equal(dobj.param("inodeId"));
        dobj.where(pred1);
        HopsQuery<CachedBlockDTO> query = session.createQuery(dobj);
        query.setParameter("inodeId", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<CachedBlock> findCachedBlockByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachedBlockDTO> dobj = qb.createQueryDefinition(CachedBlockDTO.class);
        HopsPredicate pred1 = dobj.get("inodeId").in(dobj.param("inodeId"));
        dobj.where(pred1);
        HopsQuery<CachedBlockDTO> query = session.createQuery(dobj);
        query.setParameter("inodeId", Longs.asList((long[])inodeIds));
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<CachedBlock> findByIds(long[] blockIds, long[] inodeIds, String datanodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<CachedBlock> blks = this.readCachedBlockBatch(session, inodeIds, blockIds, datanodeId);
        return blks;
    }

    public List<CachedBlock> findCachedBlockByDatanodeId(String dataNodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachedBlockDTO> dobj = qb.createQueryDefinition(CachedBlockDTO.class);
        HopsPredicate pred1 = dobj.get("dataNodeId").equal(dobj.param("dataNodeId"));
        dobj.where(pred1);
        HopsQuery<CachedBlockDTO> query = session.createQuery(dobj);
        query.setParameter("dataNodeId", dataNodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<CachedBlock> removed, Collection<CachedBlock> newed, Collection<CachedBlock> modified) throws StorageException {
        ArrayList<CachedBlockDTO> changes = new ArrayList<CachedBlockDTO>();
        ArrayList<CachedBlockDTO> deletions = new ArrayList<CachedBlockDTO>();
        HopsSession session = this.connector.obtainSession();
        try {
            CachedBlockDTO newInstance;
            for (CachedBlock cachedBlock : removed) {
                newInstance = session.newInstance(CachedBlockDTO.class);
                this.createPersistable(cachedBlock, newInstance);
                deletions.add(newInstance);
            }
            for (CachedBlock cachedBlock : newed) {
                LOG.info((Object)("GAUTIER persist cached block " + cachedBlock.getBlockId()));
                newInstance = session.newInstance(CachedBlockDTO.class);
                this.createPersistable(cachedBlock, newInstance);
                changes.add(newInstance);
            }
            for (CachedBlock cachedBlock : modified) {
                LOG.info((Object)("GAUTIER persist cached block " + cachedBlock.getBlockId()));
                newInstance = session.newInstance(CachedBlockDTO.class);
                this.createPersistable(cachedBlock, newInstance);
                changes.add(newInstance);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private List<CachedBlock> readCachedBlockBatch(HopsSession session, long[] inodeIds, long[] blockIds, String datanodeId) throws StorageException {
        ArrayList<CachedBlockDTO> bdtos = new ArrayList<CachedBlockDTO>();
        for (int i = 0; i < blockIds.length; ++i) {
            Object[] pk = new Object[]{blockIds[i], inodeIds[i], datanodeId};
            CachedBlockDTO bdto = session.newInstance(CachedBlockDTO.class, pk);
            bdto = session.load(bdto);
            bdtos.add(bdto);
        }
        session.flush();
        List<CachedBlock> lbis = this.convertAndRelease(session, bdtos);
        return lbis;
    }

    private List<CachedBlock> convertAndRelease(HopsSession session, List<CachedBlockDTO> dtos) throws StorageException {
        ArrayList<CachedBlock> cachedBlocks = new ArrayList<CachedBlock>(dtos.size());
        for (CachedBlockDTO dto : dtos) {
            cachedBlocks.add(this.convert(dto));
            session.release(dto);
        }
        return cachedBlocks;
    }

    private CachedBlock convert(CachedBlockDTO dto) {
        return new CachedBlock(dto.getBlockId(), dto.getInodeId(), dto.getDataNodeId(), dto.getStatus(), dto.getReplicationAndMark());
    }

    private void createPersistable(CachedBlock cachedBlock, CachedBlockDTO newInstance) {
        newInstance.setBlockId(cachedBlock.getBlockId());
        newInstance.setInodeId(cachedBlock.getInodeId());
        newInstance.setDataNodeId(cachedBlock.getDatanodeId());
        newInstance.setStatus(cachedBlock.getStatus());
        newInstance.setReplicationAndMark(cachedBlock.getReplicationAndMark());
    }

    @PersistenceCapable(table="hdfs_cached_block")
    public static interface CachedBlockDTO {
        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @PrimaryKey
        @Column(name="datanode_id")
        public String getDataNodeId();

        public void setDataNodeId(String var1);

        @Column(name="status")
        public String getStatus();

        public void setStatus(String var1);

        @Column(name="replication_and_mark")
        public short getReplicationAndMark();

        public void setReplicationAndMark(short var1);
    }
}

