/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.entity.UnderReplicatedBlock;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnderReplicatedBlockClusterj
implements TablesDef.UnderReplicatedBlockTableDef,
UnderReplicatedBlockDataAccess<UnderReplicatedBlock> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public int countByLevel(int level) throws StorageException {
        return MySQLQueryHelper.countWithCriterion("hdfs_under_replicated_blocks", String.format("%s=%d", "level", level));
    }

    public int countLessThanALevel(int level) throws StorageException {
        return MySQLQueryHelper.countWithCriterion("hdfs_under_replicated_blocks", String.format("%s<%d", "level", level));
    }

    public UnderReplicatedBlock findByPk(long blockId, long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{inodeId, blockId};
        UnderReplicatedBlocksDTO urbt = session.find(UnderReplicatedBlocksDTO.class, pk);
        if (urbt == null) {
            return null;
        }
        return this.convertAndRelease(session, urbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<UnderReplicatedBlock> removed, Collection<UnderReplicatedBlock> newed, Collection<UnderReplicatedBlock> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<UnderReplicatedBlocksDTO> changes = new ArrayList<UnderReplicatedBlocksDTO>();
        ArrayList<UnderReplicatedBlocksDTO> deletions = new ArrayList<UnderReplicatedBlocksDTO>();
        try {
            UnderReplicatedBlocksDTO newInstance;
            for (UnderReplicatedBlock urBlock : removed) {
                newInstance = session.newInstance(UnderReplicatedBlocksDTO.class);
                this.createPersistable(urBlock, newInstance);
                deletions.add(newInstance);
            }
            for (UnderReplicatedBlock urBlock : newed) {
                newInstance = session.newInstance(UnderReplicatedBlocksDTO.class);
                this.createPersistable(urBlock, newInstance);
                changes.add(newInstance);
            }
            for (UnderReplicatedBlock urBlock : modified) {
                newInstance = session.newInstance(UnderReplicatedBlocksDTO.class);
                this.createPersistable(urBlock, newInstance);
                changes.add(newInstance);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private void createPersistable(UnderReplicatedBlock block, UnderReplicatedBlocksDTO persistable) {
        persistable.setBlockId(block.getBlockId());
        persistable.setLevel(block.getLevel());
        persistable.setINodeId(block.getInodeId());
        persistable.setTimestamp(System.currentTimeMillis());
    }

    private UnderReplicatedBlock convertAndRelease(HopsSession session, UnderReplicatedBlocksDTO bit) throws StorageException {
        UnderReplicatedBlock block = new UnderReplicatedBlock(bit.getLevel(), bit.getBlockId(), bit.getINodeId());
        session.release(bit);
        return block;
    }

    private List<UnderReplicatedBlock> convertAndRelease(HopsSession session, List<UnderReplicatedBlocksDTO> bitList) throws StorageException {
        ArrayList<UnderReplicatedBlock> blocks = new ArrayList<UnderReplicatedBlock>();
        for (UnderReplicatedBlocksDTO bit : bitList) {
            blocks.add(this.convertAndRelease(session, bit));
        }
        return blocks;
    }

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_under_replicated_blocks");
    }

    public List<UnderReplicatedBlock> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UnderReplicatedBlocksDTO> dobj = qb.createQueryDefinition(UnderReplicatedBlocksDTO.class);
        HopsQuery<UnderReplicatedBlocksDTO> query = session.createQuery(dobj);
        query.setOrdering(Query.Ordering.ASCENDING, "level", "timestamp");
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<UnderReplicatedBlock> findByLevel(int level) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UnderReplicatedBlocksDTO> dobj = qb.createQueryDefinition(UnderReplicatedBlocksDTO.class);
        HopsPredicate pred = dobj.get("level").equal(dobj.param("level"));
        dobj.where(pred);
        HopsQuery<UnderReplicatedBlocksDTO> query = session.createQuery(dobj);
        query.setParameter("level", level);
        query.setOrdering(Query.Ordering.ASCENDING, "level", "timestamp");
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<UnderReplicatedBlock> findByLevel(int level, int offset, int count) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UnderReplicatedBlocksDTO> dobj = qb.createQueryDefinition(UnderReplicatedBlocksDTO.class);
        HopsPredicate pred = dobj.get("level").equal(dobj.param("level"));
        dobj.where(pred);
        HopsQuery<UnderReplicatedBlocksDTO> query = session.createQuery(dobj);
        query.setParameter("level", level);
        query.setOrdering(Query.Ordering.ASCENDING, "level", "timestamp");
        query.setLimits(offset, count);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<UnderReplicatedBlock> findByINodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UnderReplicatedBlocksDTO> qdt = qb.createQueryDefinition(UnderReplicatedBlocksDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").equal(qdt.param("idParam"));
        qdt.where(pred1);
        HopsQuery<UnderReplicatedBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("idParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<UnderReplicatedBlock> findByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UnderReplicatedBlocksDTO> qdt = qb.createQueryDefinition(UnderReplicatedBlocksDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").in(qdt.param("idParam"));
        qdt.where(pred1);
        HopsQuery<UnderReplicatedBlocksDTO> query = session.createQuery(qdt);
        query.setParameter("idParam", Longs.asList((long[])inodeIds));
        return this.convertAndRelease(session, query.getResultList());
    }

    public void removeAll() throws StorageException {
        try {
            while (this.countAll() != 0) {
                MysqlServerConnector.truncateTable("hdfs_under_replicated_blocks", 1000);
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
    }

    @PersistenceCapable(table="hdfs_under_replicated_blocks")
    @PartitionKey(column="inode_id")
    @Index(name="level")
    public static interface UnderReplicatedBlocksDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @Column(name="level")
        public int getLevel();

        public void setLevel(int var1);

        @Column(name="timestamp")
        public long getTimestamp();

        public void setTimestamp(long var1);
    }
}

