/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.SafeBlocksDataAccess;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class SafeBlocksClusterj
implements TablesDef.SafeBlocksTableDef,
SafeBlocksDataAccess {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Collection<Long> safeBlocks) throws StorageException {
        ArrayList<SafeBlockDTO> dtos = new ArrayList<SafeBlockDTO>(safeBlocks.size());
        HopsSession session = this.connector.obtainSession();
        try {
            for (Long blk : safeBlocks) {
                SafeBlockDTO dto = this.create(session, blk);
                dtos.add(dto);
            }
            session.savePersistentAll(dtos);
        }
        finally {
            session.release(dtos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Long safeBlock) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        SafeBlockDTO dto = null;
        try {
            dto = this.create(session, safeBlock);
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_safe_blocks");
    }

    public void removeAll() throws StorageException {
        try {
            while (this.countAll() != 0) {
                MysqlServerConnector.truncateTable("hdfs_safe_blocks", 10000);
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
    }

    private SafeBlockDTO create(HopsSession session, Long blk) throws StorageException {
        SafeBlockDTO dto = session.newInstance(SafeBlockDTO.class);
        dto.setId(blk);
        return dto;
    }

    @PersistenceCapable(table="hdfs_safe_blocks")
    public static interface SafeBlockDTO {
        @PrimaryKey
        @Column(name="id")
        public long getId();

        public void setId(long var1);
    }
}

