/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.ContainerStatusDataAccess;
import io.hops.metadata.yarn.entity.ContainerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContainerStatusClusterJ
implements TablesDef.ContainerStatusTableDef,
ContainerStatusDataAccess<ContainerStatus> {
    private static final Log LOG = LogFactory.getLog(ContainerStatusClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public ContainerStatus findEntry(String containerId, String rmNodeId, String type) throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ ContainerStatus.findById - START");
        HopsSession session = this.connector.obtainSession();
        if (session != null) {
            ContainerStatusDTO uciDTO = session.find(ContainerStatusDTO.class, new Object[]{containerId, rmNodeId, type});
            LOG.debug((Object)"HOP :: ClusterJ ContainerStatus.findById - FINISH");
            if (uciDTO != null) {
                ContainerStatus result = ContainerStatusClusterJ.createHopContainerStatus(uciDTO);
                session.release(uciDTO);
                return result;
            }
        }
        return null;
    }

    public Map<String, ContainerStatus> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ ContainerStatus.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerStatusDTO> dobj = qb.createQueryDefinition(ContainerStatusDTO.class);
        HopsQuery<ContainerStatusDTO> query = session.createQuery(dobj);
        List<ContainerStatusDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ ContainerStatus.getAll - START");
        Map<String, ContainerStatus> result = ContainerStatusClusterJ.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(Collection<ContainerStatus> containersStatus) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerStatusDTO> toAdd = new ArrayList<ContainerStatusDTO>();
        for (ContainerStatus containerStatus : containersStatus) {
            toAdd.add(this.createPersistable(containerStatus, session));
        }
        session.savePersistentAll(toAdd);
        session.release(toAdd);
    }

    public void removeAll(Collection<ContainerStatus> containersStatus) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerStatusDTO> toRemove = new ArrayList<ContainerStatusDTO>();
        for (ContainerStatus containerStatus : containersStatus) {
            toRemove.add(this.createPersistable(containerStatus, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    private ContainerStatusDTO createPersistable(ContainerStatus hopCS, HopsSession session) throws StorageException {
        ContainerStatusDTO csDTO = session.newInstance(ContainerStatusDTO.class);
        csDTO.setcontainerid(hopCS.getContainerid());
        csDTO.setstate(hopCS.getState());
        csDTO.setdiagnostics(hopCS.getDiagnostics());
        csDTO.setexitstatus(hopCS.getExitstatus());
        csDTO.setrmnodeid(hopCS.getRMNodeId());
        csDTO.setpendingeventid(hopCS.getPendingEventId());
        csDTO.setuciid(hopCS.getUciId());
        return csDTO;
    }

    private static ContainerStatus createHopContainerStatus(ContainerStatusDTO csDTO) {
        ContainerStatus hop = new ContainerStatus(csDTO.getcontainerid(), csDTO.getstate(), csDTO.getdiagnostics(), csDTO.getexitstatus(), csDTO.getrmnodeid(), csDTO.getpendingeventid(), csDTO.getuciid());
        return hop;
    }

    public static Map<String, ContainerStatus> createMap(List<ContainerStatusDTO> results) {
        HashMap<String, ContainerStatus> map = new HashMap<String, ContainerStatus>();
        for (ContainerStatusDTO persistable : results) {
            ContainerStatus hop = ContainerStatusClusterJ.createHopContainerStatus(persistable);
            map.put(hop.getContainerid(), hop);
        }
        return map;
    }

    public static List<ContainerStatus> createList(List<ContainerStatusDTO> results) {
        ArrayList<ContainerStatus> list = new ArrayList<ContainerStatus>();
        for (ContainerStatusDTO persistable : results) {
            ContainerStatus hop = ContainerStatusClusterJ.createHopContainerStatus(persistable);
            list.add(hop);
        }
        return list;
    }

    @PersistenceCapable(table="yarn_containerstatus")
    public static interface ContainerStatusDTO {
        @PrimaryKey
        @Column(name="containerid")
        public String getcontainerid();

        public void setcontainerid(String var1);

        @PrimaryKey
        @Column(name="rmnodeid")
        public String getrmnodeid();

        public void setrmnodeid(String var1);

        @PrimaryKey
        @Column(name="uciid")
        public int getuciid();

        public void setuciid(int var1);

        @Column(name="state")
        public String getstate();

        public void setstate(String var1);

        @Column(name="diagnostics")
        public String getdiagnostics();

        public void setdiagnostics(String var1);

        @Column(name="exitstatus")
        public int getexitstatus();

        public void setexitstatus(int var1);

        @Column(name="pendingeventid")
        public int getpendingeventid();

        public void setpendingeventid(int var1);
    }
}

