/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;

public class RetryCacheEntryClusterj
implements TablesDef.RetryCacheEntryTableDef,
RetryCacheEntryDataAccess {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public RetryCacheEntry find(RetryCacheEntry.PrimaryKey key) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{key.getClientId(), key.getCallId()};
        RetryCacheEntryDTO result = session.find(RetryCacheEntryDTO.class, pk);
        if (result != null) {
            RetryCacheEntry retryCacheEntry = this.convert(result);
            session.release(result);
            return retryCacheEntry;
        }
        return null;
    }

    public void prepare(Collection<RetryCacheEntry> removed, Collection<RetryCacheEntry> modified) throws StorageException {
        RetryCacheEntryDTO newInstance;
        ArrayList<RetryCacheEntryDTO> changes = new ArrayList<RetryCacheEntryDTO>();
        ArrayList<RetryCacheEntryDTO> deletions = new ArrayList<RetryCacheEntryDTO>();
        HopsSession session = this.connector.obtainSession();
        for (RetryCacheEntry retryCacheEntry : removed) {
            newInstance = session.newInstance(RetryCacheEntryDTO.class);
            this.createPersistable(retryCacheEntry, newInstance);
            deletions.add(newInstance);
        }
        for (RetryCacheEntry retryCacheEntry : modified) {
            newInstance = session.newInstance(RetryCacheEntryDTO.class);
            this.createPersistable(retryCacheEntry, newInstance);
            changes.add(newInstance);
        }
        session.deletePersistentAll(deletions);
        session.savePersistentAll(changes);
        session.release(deletions);
        session.release(changes);
    }

    public void removeOlds(long time) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<RetryCacheEntryDTO> dobj = qb.createQueryDefinition(RetryCacheEntryDTO.class);
        HopsPredicate pred1 = dobj.get("expirationTime").lessEqual(dobj.param("ExpirationTime"));
        dobj.where(pred1);
        HopsQuery<RetryCacheEntryDTO> query = session.createQuery(dobj);
        query.setParameter("ExpirationTime", time);
        query.deletePersistentAll();
    }

    private RetryCacheEntry convert(RetryCacheEntryDTO result) {
        return new RetryCacheEntry(result.getClientId(), result.getCallId(), result.getPayload(), result.getExpirationTime(), result.getState());
    }

    private void createPersistable(RetryCacheEntry retryCacheEntry, RetryCacheEntryDTO newInstance) {
        newInstance.setClientId(retryCacheEntry.getClientId());
        newInstance.setCallId(retryCacheEntry.getCallId());
        newInstance.setPayload(retryCacheEntry.getPayload());
        newInstance.setExpirationTime(retryCacheEntry.getExpirationTime());
        newInstance.setState(retryCacheEntry.getState());
    }

    @PersistenceCapable(table="hdfs_retry_cache_entry")
    public static interface RetryCacheEntryDTO {
        @PrimaryKey
        @Column(name="client_id")
        public byte[] getClientId();

        public void setClientId(byte[] var1);

        @PrimaryKey
        @Column(name="call_id")
        public int getCallId();

        public void setCallId(int var1);

        @Column(name="payload")
        public byte[] getPayload();

        public void setPayload(byte[] var1);

        @Column(name="expiration_time")
        public long getExpirationTime();

        public void setExpirationTime(long var1);

        @Column(name="state")
        public byte getState();

        public void setState(byte var1);
    }
}

