/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.entity.FileInodeData;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsSession;
import org.apache.log4j.Logger;

public class SmallOnDiskFileInodeClusterj
implements TablesDef.FileInodeSmallDiskData,
SmallOnDiskInodeDataAccess<FileInodeData> {
    static final Logger LOG = Logger.getLogger(SmallOnDiskFileInodeClusterj.class);
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public void add(FileInodeData fileInodeData) throws StorageException {
        if (fileInodeData.getDBFileStorageType() != FileInodeData.Type.OnDiskFile) {
            throw new IllegalArgumentException("Expecting on disk file object. Got: " + fileInodeData.getDBFileStorageType());
        }
        HopsSession session = this.connector.obtainSession();
        FileInodeDataDTO dto = session.newInstance(FileInodeDataDTO.class);
        dto.setInodeId(fileInodeData.getInodeId());
        dto.setData(fileInodeData.getInodeData());
        session.savePersistent(dto);
        session.release(dto);
    }

    public void delete(FileInodeData fileInodeData) throws StorageException {
        if (fileInodeData.getDBFileStorageType() != FileInodeData.Type.OnDiskFile) {
            throw new IllegalArgumentException("Expecting on disk file object. Got: " + fileInodeData.getDBFileStorageType());
        }
        HopsSession session = this.connector.obtainSession();
        session.deletePersistent(FileInodeDataDTO.class, fileInodeData.getInodeId());
    }

    public FileInodeData get(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        FileInodeDataDTO dataDto = session.find(FileInodeDataDTO.class, inodeId);
        if (dataDto != null) {
            byte[] data = new byte[dataDto.getData().length];
            System.arraycopy(dataDto.getData(), 0, data, 0, data.length);
            FileInodeData fileData = new FileInodeData(inodeId, data, data.length, FileInodeData.Type.OnDiskFile);
            session.release(dataDto);
            return fileData;
        }
        return null;
    }

    public int count() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_ondisk_small_file_inode_data");
    }

    @PersistenceCapable(table="hdfs_ondisk_small_file_inode_data")
    public static interface FileInodeDataDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @Column(name="data")
        public byte[] getData();

        public void setData(byte[] var1);
    }
}

