/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.yarn.RMNodeComponentDTO;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.NextHeartbeatDataAccess;
import io.hops.metadata.yarn.entity.NextHeartbeat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NextHeartbeatClusterJ
implements TablesDef.NextHeartbeatTableDef,
NextHeartbeatDataAccess<NextHeartbeat> {
    private static final Log LOG = LogFactory.getLog(NextHeartbeatClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Map<String, Boolean> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<NextHeartbeatDTO> dobj = qb.createQueryDefinition(NextHeartbeatDTO.class);
        HopsQuery<NextHeartbeatDTO> query = session.createQuery(dobj);
        List<NextHeartbeatDTO> queryResults = query.getResultList();
        Map<String, Boolean> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public boolean findEntry(String rmnodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        NextHeartbeatDTO nextHBDTO = session.find(NextHeartbeatDTO.class, rmnodeId);
        boolean result = false;
        if (nextHBDTO != null) {
            result = NextHeartbeatClusterJ.createHopNextHeartbeat(nextHBDTO).isNextheartbeat();
        }
        session.release(nextHBDTO);
        return result;
    }

    public void updateAll(Collection<NextHeartbeat> toUpdate) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<NextHeartbeatDTO> toPersist = new ArrayList<NextHeartbeatDTO>();
        ArrayList<NextHeartbeatDTO> toRemove = new ArrayList<NextHeartbeatDTO>();
        for (NextHeartbeat hb : toUpdate) {
            NextHeartbeatDTO hbDTO = this.createPersistable(hb, session);
            if (hb.isNextheartbeat()) {
                toPersist.add(hbDTO);
                continue;
            }
            toRemove.add(hbDTO);
        }
        session.savePersistentAll(toPersist);
        session.deletePersistentAll(toRemove);
        session.release(toPersist);
        session.release(toRemove);
    }

    public void update(NextHeartbeat toUpdate) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        NextHeartbeatDTO hbDTO = this.createPersistable(toUpdate, session);
        if (toUpdate.isNextheartbeat()) {
            session.savePersistent(hbDTO);
        } else {
            session.deletePersistent(hbDTO);
        }
        session.release(hbDTO);
    }

    private NextHeartbeatDTO createPersistable(NextHeartbeat hopNextHeartbeat, HopsSession session) throws StorageException {
        NextHeartbeatDTO DTO = session.newInstance(NextHeartbeatDTO.class);
        DTO.setrmnodeid(hopNextHeartbeat.getRmnodeid());
        DTO.setNextheartbeat(NextHeartbeat.booleanToInt((boolean)hopNextHeartbeat.isNextheartbeat()));
        return DTO;
    }

    public static NextHeartbeat createHopNextHeartbeat(NextHeartbeatDTO nextHBDTO) {
        return new NextHeartbeat(nextHBDTO.getrmnodeid(), NextHeartbeat.intToBoolean((int)nextHBDTO.getNextheartbeat()));
    }

    private Map<String, Boolean> createMap(List<NextHeartbeatDTO> results) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (NextHeartbeatDTO persistable : results) {
            map.put(persistable.getrmnodeid(), NextHeartbeat.intToBoolean((int)persistable.getNextheartbeat()));
        }
        return map;
    }

    @PersistenceCapable(table="yarn_nextheartbeat")
    public static interface NextHeartbeatDTO
    extends RMNodeComponentDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getrmnodeid();

        public void setrmnodeid(String var1);

        @Column(name="nextheartbeat")
        public int getNextheartbeat();

        public void setNextheartbeat(int var1);
    }
}

