/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.yarn.RMNodeComponentDTO;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.RMNodeDataAccess;
import io.hops.metadata.yarn.entity.RMNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMNodeClusterJ
implements TablesDef.RMNodeTableDef,
RMNodeDataAccess<RMNode> {
    private static final Log LOG = LogFactory.getLog(RMNodeClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public RMNode findByNodeId(String nodeid) throws StorageException {
        LOG.debug((Object)("HOP :: ClusterJ RMNode.findByNodeId - START:" + nodeid));
        HopsSession session = this.connector.obtainSession();
        RMNodeDTO rmnodeDTO = session.find(RMNodeDTO.class, nodeid);
        RMNode result = null;
        if (rmnodeDTO != null) {
            LOG.debug((Object)("HOP :: ClusterJ RMNode.findByNodeId - FINISH:" + nodeid));
            result = RMNodeClusterJ.createHopRMNode(rmnodeDTO);
        }
        LOG.debug((Object)("HOP :: ClusterJ RMNode.findByNodeId - FINISH:" + nodeid));
        session.release(rmnodeDTO);
        return result;
    }

    public Map<String, RMNode> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ RMNode.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<RMNodeDTO> dobj = qb.createQueryDefinition(RMNodeDTO.class);
        HopsQuery<RMNodeDTO> query = session.createQuery(dobj);
        List<RMNodeDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ RMNode.getAll - FINISH");
        Map<String, RMNode> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(List<RMNode> toAdd) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<RMNodeDTO> toPersist = new ArrayList<RMNodeDTO>();
        Collections.sort(toAdd);
        for (RMNode req : toAdd) {
            toPersist.add(this.createPersistable(req, session));
        }
        session.savePersistentAll(toPersist);
        session.release(toPersist);
    }

    public void removeAll(Collection<RMNode> toRemove) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<RMNodeDTO> toPersist = new ArrayList<RMNodeDTO>();
        for (RMNode entry : toRemove) {
            toPersist.add(session.newInstance(RMNodeDTO.class, entry.getNodeId()));
        }
        session.deletePersistentAll(toPersist);
        session.release(toPersist);
    }

    public void add(RMNode rmNode) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        RMNodeDTO dto = this.createPersistable(rmNode, session);
        session.savePersistent(dto);
        session.release(dto);
    }

    private Map<String, RMNode> createMap(List<RMNodeDTO> results) {
        HashMap<String, RMNode> map = new HashMap<String, RMNode>();
        for (RMNodeDTO persistable : results) {
            RMNode hop = RMNodeClusterJ.createHopRMNode(persistable);
            map.put(hop.getNodeId(), hop);
        }
        return map;
    }

    private RMNodeDTO createPersistable(RMNode hopRMNode, HopsSession session) throws StorageException {
        RMNodeDTO rmDTO = session.newInstance(RMNodeDTO.class);
        rmDTO.setNodeid(hopRMNode.getNodeId());
        rmDTO.setHostname(hopRMNode.getHostName());
        rmDTO.setCommandport(hopRMNode.getCommandPort());
        rmDTO.setHttpport(hopRMNode.getHttpPort());
        rmDTO.setHealthreport(hopRMNode.getHealthReport());
        rmDTO.setLasthealthreporttime(hopRMNode.getLastHealthReportTime());
        rmDTO.setcurrentstate(hopRMNode.getCurrentState());
        rmDTO.setnodemanagerversion(hopRMNode.getNodemanagerVersion());
        rmDTO.setpendingeventid(hopRMNode.getPendingEventId());
        return rmDTO;
    }

    public static RMNode createHopRMNode(RMNodeDTO rmDTO) {
        return new RMNode(rmDTO.getNodeid(), rmDTO.getHostname(), rmDTO.getCommandport(), rmDTO.getHttpport(), rmDTO.getHealthreport(), rmDTO.getLasthealthreporttime(), rmDTO.getcurrentstate(), rmDTO.getnodemanagerversion(), rmDTO.getpendingeventid());
    }

    @PersistenceCapable(table="yarn_rmnode")
    public static interface RMNodeDTO
    extends RMNodeComponentDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getNodeid();

        public void setNodeid(String var1);

        @Column(name="hostname")
        public String getHostname();

        public void setHostname(String var1);

        @Column(name="commandport")
        public int getCommandport();

        public void setCommandport(int var1);

        @Column(name="httpport")
        public int getHttpport();

        public void setHttpport(int var1);

        @Column(name="healthreport")
        public String getHealthreport();

        public void setHealthreport(String var1);

        @Column(name="lasthealthreporttime")
        public long getLasthealthreporttime();

        public void setLasthealthreporttime(long var1);

        @Column(name="currentstate")
        public String getcurrentstate();

        public void setcurrentstate(String var1);

        @Column(name="nodemanager_version")
        public String getnodemanagerversion();

        public void setnodemanagerversion(String var1);

        @Column(name="pendingeventid")
        public int getpendingeventid();

        public void setpendingeventid(int var1);
    }
}

