/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.UpdatedContainerInfoDataAccess;
import io.hops.metadata.yarn.entity.UpdatedContainerInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatedContainerInfoClusterJ
implements TablesDef.UpdatedContainerInfoTableDef,
UpdatedContainerInfoDataAccess<UpdatedContainerInfo> {
    private static final Log LOG = LogFactory.getLog(UpdatedContainerInfoClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Map<Integer, List<UpdatedContainerInfo>> findByRMNode(String rmnodeid) throws StorageException {
        LOG.debug((Object)("HOP :: ClusterJ UpdatedContainerInfo.findByRMNode - START:" + rmnodeid));
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UpdatedContainerInfoDTO> dobj = qb.createQueryDefinition(UpdatedContainerInfoDTO.class);
        HopsPredicate pred1 = dobj.get("rmnodeid").equal(dobj.param("rmnodeid"));
        dobj.where(pred1);
        HopsQuery<UpdatedContainerInfoDTO> query = session.createQuery(dobj);
        query.setParameter("rmnodeid", rmnodeid);
        List<UpdatedContainerInfoDTO> queryResults = query.getResultList();
        LOG.debug((Object)("HOP :: ClusterJ UpdatedContainerInfo.findByRMNode - FINISH:" + rmnodeid));
        Map<Integer, List<UpdatedContainerInfo>> result = null;
        if (queryResults != null && !queryResults.isEmpty()) {
            result = this.createUpdatedContainerInfoMap(queryResults);
        }
        session.release(queryResults);
        return result;
    }

    public List<UpdatedContainerInfo> findByRMNodeList(String rmnodeid) throws StorageException {
        List<UpdatedContainerInfoDTO> results = this.findByRMNodeInt(rmnodeid);
        if (results != null && !results.isEmpty()) {
            return this.createUpdatedContainerInfoList(results);
        }
        return null;
    }

    private List<UpdatedContainerInfoDTO> findByRMNodeInt(String rmnodeid) throws StorageException {
        LOG.debug((Object)("HOP :: ClusterJ UpdatedContainerInfo.findByRMNode - START:" + rmnodeid));
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UpdatedContainerInfoDTO> dobj = qb.createQueryDefinition(UpdatedContainerInfoDTO.class);
        HopsPredicate pred1 = dobj.get("rmnodeid").equal(dobj.param("rmnodeid"));
        dobj.where(pred1);
        HopsQuery<UpdatedContainerInfoDTO> query = session.createQuery(dobj);
        query.setParameter("rmnodeid", rmnodeid);
        List<UpdatedContainerInfoDTO> results = query.getResultList();
        LOG.debug((Object)("HOP :: ClusterJ UpdatedContainerInfo.findByRMNode - FINISH:" + rmnodeid));
        return results;
    }

    public Map<String, Map<Integer, List<UpdatedContainerInfo>>> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ UpdatedContainerInfo.findByRMNode - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UpdatedContainerInfoDTO> dobj = qb.createQueryDefinition(UpdatedContainerInfoDTO.class);
        HopsQuery<UpdatedContainerInfoDTO> query = session.createQuery(dobj);
        List<UpdatedContainerInfoDTO> results = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ UpdatedContainerInfo.findByRMNode - FINISH");
        return this.createMap(results);
    }

    public void addAll(Collection<UpdatedContainerInfo> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<UpdatedContainerInfoDTO> toModify = new ArrayList<UpdatedContainerInfoDTO>();
        for (UpdatedContainerInfo entry : containers) {
            toModify.add(this.createPersistable(entry, session));
        }
        session.savePersistentAll(toModify);
        session.release(toModify);
    }

    public void removeAll(Collection<UpdatedContainerInfo> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<UpdatedContainerInfoDTO> toRemove = new ArrayList<UpdatedContainerInfoDTO>();
        for (UpdatedContainerInfo entry : containers) {
            toRemove.add(this.createPersistable(entry, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    private UpdatedContainerInfoDTO createPersistable(UpdatedContainerInfo hop, HopsSession session) throws StorageException {
        UpdatedContainerInfoDTO dto = session.newInstance(UpdatedContainerInfoDTO.class);
        dto.setrmnodeid(hop.getRmnodeid());
        dto.setcontainerid(hop.getContainerId());
        dto.setupdatedcontainerinfoid(hop.getUpdatedContainerInfoId());
        dto.setpendingeventid(hop.getPendingEventId());
        return dto;
    }

    private UpdatedContainerInfo createHopUpdatedContainerInfo(UpdatedContainerInfoDTO dto) {
        return new UpdatedContainerInfo(dto.getrmnodeid(), dto.getcontainerid(), dto.getupdatedcontainerinfoid(), dto.getpendingeventid());
    }

    private Map<Integer, List<UpdatedContainerInfo>> createUpdatedContainerInfoMap(List<UpdatedContainerInfoDTO> list) {
        HashMap<Integer, List<UpdatedContainerInfo>> updatedContainerInfos = new HashMap<Integer, List<UpdatedContainerInfo>>();
        for (UpdatedContainerInfoDTO persistable : list) {
            if (!updatedContainerInfos.containsKey(persistable.getupdatedcontainerinfoid())) {
                updatedContainerInfos.put(persistable.getupdatedcontainerinfoid(), new ArrayList());
            }
            ((List)updatedContainerInfos.get(persistable.getupdatedcontainerinfoid())).add(this.createHopUpdatedContainerInfo(persistable));
        }
        return updatedContainerInfos;
    }

    private List<UpdatedContainerInfo> createUpdatedContainerInfoList(List<UpdatedContainerInfoDTO> list) {
        ArrayList<UpdatedContainerInfo> updatedContainerInfos = new ArrayList<UpdatedContainerInfo>();
        for (UpdatedContainerInfoDTO persistable : list) {
            updatedContainerInfos.add(this.createHopUpdatedContainerInfo(persistable));
        }
        return updatedContainerInfos;
    }

    private Map<String, Map<Integer, List<UpdatedContainerInfo>>> createMap(List<UpdatedContainerInfoDTO> results) {
        HashMap<String, Map<Integer, List<UpdatedContainerInfo>>> map = new HashMap<String, Map<Integer, List<UpdatedContainerInfo>>>();
        for (UpdatedContainerInfoDTO persistable : results) {
            UpdatedContainerInfo hop = this.createHopUpdatedContainerInfo(persistable);
            if (map.get(hop.getRmnodeid()) == null) {
                map.put(hop.getRmnodeid(), new HashMap());
            }
            if (((Map)map.get(hop.getRmnodeid())).get(hop.getUpdatedContainerInfoId()) == null) {
                ((Map)map.get(hop.getRmnodeid())).put(hop.getUpdatedContainerInfoId(), new ArrayList());
            }
            ((List)((Map)map.get(hop.getRmnodeid())).get(hop.getUpdatedContainerInfoId())).add(hop);
        }
        return map;
    }

    @PersistenceCapable(table="yarn_updatedcontainerinfo")
    public static interface UpdatedContainerInfoDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getrmnodeid();

        public void setrmnodeid(String var1);

        @PrimaryKey
        @Column(name="containerid")
        public String getcontainerid();

        public void setcontainerid(String var1);

        @PrimaryKey
        @Column(name="updatedcontainerinfoid")
        public int getupdatedcontainerinfoid();

        public void setupdatedcontainerinfoid(int var1);

        @Column(name="pendingeventid")
        public int getpendingeventid();

        public void setpendingeventid(int var1);
    }
}

