/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.quota;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.quota.ContainersLogsDataAccess;
import io.hops.metadata.yarn.entity.quota.ContainerLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainersLogsClusterJ
implements TablesDef.ContainersLogsTableDef,
ContainersLogsDataAccess<ContainerLog> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public void addAll(Collection<ContainerLog> containersLogs) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerLogDTO> toAdd = new ArrayList<ContainerLogDTO>();
        for (ContainerLog entry : containersLogs) {
            toAdd.add(this.createPersistable(entry, session));
        }
        session.savePersistentAll(toAdd);
        session.release(toAdd);
    }

    public void removeAll(Collection<ContainerLog> containersLogs) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerLogDTO> toRemove = new ArrayList<ContainerLogDTO>();
        for (ContainerLog entry : containersLogs) {
            toRemove.add(this.createPersistable(entry, session));
        }
        session.deletePersistentAll(toRemove);
        session.flush();
        session.release(toRemove);
    }

    public Map<String, ContainerLog> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerLogDTO> dobj = qb.createQueryDefinition(ContainerLogDTO.class);
        HopsQuery<ContainerLogDTO> query = session.createQuery(dobj);
        List<ContainerLogDTO> queryResults = query.getResultList();
        Map<String, ContainerLog> result = ContainersLogsClusterJ.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    private ContainerLogDTO createPersistable(ContainerLog hopCL, HopsSession session) throws StorageException {
        ContainerLogDTO clDTO = session.newInstance(ContainerLogDTO.class);
        clDTO.setcontainerid(hopCL.getContainerid());
        clDTO.setstart(hopCL.getStart());
        clDTO.setstop(hopCL.getStop());
        clDTO.setexitstatus(hopCL.getExitstatus());
        clDTO.setPrice(hopCL.getPrice());
        clDTO.setVCores(hopCL.getNbVcores());
        clDTO.setMB(hopCL.getMemoryUsed());
        clDTO.setGpus(hopCL.getGpuUsed());
        return clDTO;
    }

    private static Map<String, ContainerLog> createMap(List<ContainerLogDTO> results) {
        HashMap<String, ContainerLog> map = new HashMap<String, ContainerLog>();
        for (ContainerLogDTO persistable : results) {
            ContainerLog hop = ContainersLogsClusterJ.createHopContainerLog(persistable);
            map.put(hop.getContainerid(), hop);
        }
        return map;
    }

    private static ContainerLog createHopContainerLog(ContainerLogDTO clDTO) {
        ContainerLog hop = new ContainerLog(clDTO.getcontainerid(), clDTO.getstart(), clDTO.getstop(), clDTO.getexitstatus(), clDTO.getPrice(), clDTO.getVCores(), clDTO.getMB(), clDTO.getGpus());
        return hop;
    }

    @PersistenceCapable(table="yarn_containers_logs")
    public static interface ContainerLogDTO {
        @PrimaryKey
        @Column(name="container_id")
        public String getcontainerid();

        public void setcontainerid(String var1);

        @Column(name="start")
        public long getstart();

        public void setstart(long var1);

        @Column(name="stop")
        public long getstop();

        public void setstop(long var1);

        @Column(name="exit_status")
        public int getexitstatus();

        public void setexitstatus(int var1);

        @Column(name="price")
        public float getPrice();

        public void setPrice(float var1);

        @Column(name="vcores")
        public int getVCores();

        public void setVCores(int var1);

        @Column(name="mb")
        public long getMB();

        public void setMB(long var1);

        @Column(name="gpus")
        public int getGpus();

        public void setGpus(int var1);
    }
}

