/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.quota;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.quota.ProjectsDailyCostDataAccess;
import io.hops.metadata.yarn.entity.quota.ProjectDailyCost;
import io.hops.metadata.yarn.entity.quota.ProjectDailyId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectsDailyCostClusterJ
implements TablesDef.ProjectsDailyCostTableDef,
ProjectsDailyCostDataAccess<ProjectDailyCost> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Map<ProjectDailyId, ProjectDailyCost> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ProjectDailyCostDTO> dobj = qb.createQueryDefinition(ProjectDailyCostDTO.class);
        HopsQuery<ProjectDailyCostDTO> query = session.createQuery(dobj);
        List<ProjectDailyCostDTO> queryResults = query.getResultList();
        Map<ProjectDailyId, ProjectDailyCost> result = ProjectsDailyCostClusterJ.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public Map<ProjectDailyId, ProjectDailyCost> getByDay(long day) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ProjectDailyCostDTO> dobj = qb.createQueryDefinition(ProjectDailyCostDTO.class);
        HopsPredicate predicate = dobj.get("day").equal(dobj.param("day"));
        dobj.where(predicate);
        HopsQuery<ProjectDailyCostDTO> query = session.createQuery(dobj);
        query.setParameter("day", day);
        List<ProjectDailyCostDTO> dtos = query.getResultList();
        Map<ProjectDailyId, ProjectDailyCost> result = ProjectsDailyCostClusterJ.createMap(dtos);
        session.release(dtos);
        return result;
    }

    public static Map<ProjectDailyId, ProjectDailyCost> createMap(List<ProjectDailyCostDTO> results) {
        HashMap<ProjectDailyId, ProjectDailyCost> map = new HashMap<ProjectDailyId, ProjectDailyCost>();
        for (ProjectDailyCostDTO persistable : results) {
            ProjectDailyCost hop = ProjectsDailyCostClusterJ.createHopProjectDailyCost(persistable);
            map.put(new ProjectDailyId(hop.getProjectName(), hop.getProjectUser(), hop.getDay()), hop);
        }
        return map;
    }

    private static ProjectDailyCost createHopProjectDailyCost(ProjectDailyCostDTO csDTO) {
        ProjectDailyCost hop = new ProjectDailyCost(csDTO.getProjectName(), csDTO.getUser(), csDTO.getDay(), csDTO.getCreditUsed(), csDTO.getAppIds());
        return hop;
    }

    public void addAll(Collection<ProjectDailyCost> yarnProjectDailyCost) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ProjectDailyCostDTO> toAdd = new ArrayList<ProjectDailyCostDTO>();
        for (ProjectDailyCost _yarnProjectDailyCost : yarnProjectDailyCost) {
            toAdd.add(this.createPersistable(_yarnProjectDailyCost, session));
        }
        session.savePersistentAll(toAdd);
        session.release(toAdd);
    }

    private ProjectDailyCostDTO createPersistable(ProjectDailyCost hopPQ, HopsSession session) throws StorageException {
        ProjectDailyCostDTO pqDTO = session.newInstance(ProjectDailyCostDTO.class);
        pqDTO.setProjectName(hopPQ.getProjectName());
        pqDTO.setUser(hopPQ.getProjectUser());
        pqDTO.setDay(hopPQ.getDay());
        pqDTO.setCreditUsed(hopPQ.getCreditsUsed());
        String appIds = "";
        for (String appId : hopPQ.getAppIds()) {
            appIds = appIds + appId + ",";
        }
        if (appIds.length() > 3000) {
            appIds = appIds.substring(0, 2997) + "...";
        }
        pqDTO.setAppIds(appIds);
        return pqDTO;
    }

    @PersistenceCapable(table="yarn_projects_daily_cost")
    public static interface ProjectDailyCostDTO {
        @PrimaryKey
        @Column(name="projectname")
        public String getProjectName();

        public void setProjectName(String var1);

        @PrimaryKey
        @Column(name="user")
        public String getUser();

        public void setUser(String var1);

        @PrimaryKey
        @Column(name="day")
        public long getDay();

        public void setDay(long var1);

        @Column(name="credits_used")
        public float getCreditUsed();

        public void setCreditUsed(float var1);

        @Column(name="app_ids")
        public String getAppIds();

        public void setAppIds(String var1);
    }
}

