/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QuotaUpdateClusterj
implements TablesDef.QuotaUpdateTableDef,
QuotaUpdateDataAccess<QuotaUpdate> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private MysqlServerConnector mysqlConnector = MysqlServerConnector.getInstance();
    private static final String FIND_QUERY = "SELECT * FROM hdfs_quota_update ORDER BY id LIMIT ";
    private static final String INODE_ID_PARAM = "inodeId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<QuotaUpdate> added, Collection<QuotaUpdate> removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<QuotaUpdateDTO> changes = new ArrayList<QuotaUpdateDTO>();
        ArrayList<QuotaUpdateDTO> deletions = new ArrayList<QuotaUpdateDTO>();
        try {
            QuotaUpdateDTO persistable;
            if (removed != null) {
                for (QuotaUpdate update : removed) {
                    persistable = this.createPersistable(update, session);
                    deletions.add(persistable);
                }
            }
            if (added != null) {
                for (QuotaUpdate update : added) {
                    persistable = this.createPersistable(update, session);
                    changes.add(persistable);
                }
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public List<QuotaUpdate> findLimited(int limit) throws StorageException {
        ArrayList<QuotaUpdate> resultList;
        try {
            Connection conn = this.mysqlConnector.obtainSession();
            PreparedStatement s = conn.prepareStatement(FIND_QUERY + limit);
            ResultSet result = s.executeQuery();
            resultList = new ArrayList<QuotaUpdate>();
            while (result.next()) {
                int id = result.getInt("id");
                int inodeId = result.getInt("inode_id");
                int namespaceDelta = result.getInt("namespace_delta");
                long diskspaceDelta = result.getLong("diskspace_delta");
                resultList.add(new QuotaUpdate(id, (long)inodeId, (long)namespaceDelta, diskspaceDelta));
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
        finally {
            this.mysqlConnector.closeSession();
        }
        return resultList;
    }

    private QuotaUpdateDTO createPersistable(QuotaUpdate update, HopsSession session) throws StorageException {
        QuotaUpdateDTO dto = session.newInstance(QuotaUpdateDTO.class);
        dto.setId(update.getId());
        dto.setInodeId(update.getInodeId());
        dto.setNamespaceDelta(update.getNamespaceDelta());
        dto.setDiskspaceDelta(update.getDiskspaceDelta());
        return dto;
    }

    private List<QuotaUpdate> convertAndRelease(HopsSession session, List<QuotaUpdateDTO> list) throws StorageException {
        ArrayList<QuotaUpdate> result = new ArrayList<QuotaUpdate>();
        for (QuotaUpdateDTO dto : list) {
            result.add(new QuotaUpdate(dto.getId(), dto.getInodeId(), dto.getNamespaceDelta(), dto.getDiskspaceDelta()));
            session.release(dto);
        }
        return result;
    }

    public List<QuotaUpdate> findByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<QuotaUpdateDTO> dobj = qb.createQueryDefinition(QuotaUpdateDTO.class);
        HopsPredicate pred1 = dobj.get(INODE_ID_PARAM).equal(dobj.param(INODE_ID_PARAM));
        dobj.where(pred1);
        HopsQuery<QuotaUpdateDTO> query = session.createQuery(dobj);
        query.setParameter(INODE_ID_PARAM, inodeId);
        List<QuotaUpdateDTO> results = query.getResultList();
        return this.convertAndRelease(session, results);
    }

    public int getCount() throws StorageException {
        int count = MySQLQueryHelper.countAll("hdfs_quota_update");
        return count;
    }

    @PersistenceCapable(table="hdfs_quota_update")
    public static interface QuotaUpdateDTO {
        @PrimaryKey
        @Column(name="id")
        public int getId();

        public void setId(int var1);

        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @Column(name="namespace_delta")
        public long getNamespaceDelta();

        public void setNamespaceDelta(long var1);

        @Column(name="diskspace_delta")
        public long getDiskspaceDelta();

        public void setDiskspaceDelta(long var1);
    }
}

