/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.wrapper;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import io.hops.exception.ForeignKeyConstraintViolationException;
import io.hops.exception.OutOfDBExtentsException;
import io.hops.exception.StorageException;
import io.hops.exception.TransientStorageException;
import io.hops.exception.TupleAlreadyExistedException;
import io.hops.exception.UniqueKeyConstraintViolationException;

public class HopsExceptionHelper {
    public static StorageException wrap(ClusterJException e) {
        if (HopsExceptionHelper.isTransient(e)) {
            return new TransientStorageException((Throwable)e);
        }
        if (HopsExceptionHelper.isTupleAlreadyExisted(e)) {
            return new TupleAlreadyExistedException((Throwable)e);
        }
        if (HopsExceptionHelper.isForeignKeyConstraintViolation(e)) {
            return new ForeignKeyConstraintViolationException((Throwable)e);
        }
        if (HopsExceptionHelper.isUniqueKeyConstraintViolation(e)) {
            return new UniqueKeyConstraintViolationException((Throwable)e);
        }
        if (HopsExceptionHelper.isOutOfDBExtents(e)) {
            return new OutOfDBExtentsException((Throwable)e);
        }
        return new StorageException((Throwable)e);
    }

    private static boolean isTransient(ClusterJException e) {
        int classification;
        return e instanceof ClusterJDatastoreException && ((classification = ((ClusterJDatastoreException)e).getClassification()) == ClusterJDatastoreException.Classification.TemporaryResourceError.value || classification == ClusterJDatastoreException.Classification.NodeRecoveryError.value || classification == ClusterJDatastoreException.Classification.OverloadError.value || classification == ClusterJDatastoreException.Classification.TimeoutExpired.value || classification == ClusterJDatastoreException.Classification.NodeShutdown.value || classification == ClusterJDatastoreException.Classification.InternalTemporary.value);
    }

    private static boolean isTupleAlreadyExisted(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, 630);
    }

    private static boolean isForeignKeyConstraintViolation(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, 255);
    }

    private static boolean isUniqueKeyConstraintViolation(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, 893);
    }

    private static boolean isOutOfDBExtents(ClusterJException e) {
        return HopsExceptionHelper.isExceptionContains(e, 1601);
    }

    private static boolean isExceptionContains(ClusterJException e, int code) {
        return e instanceof ClusterJDatastoreException && ((ClusterJDatastoreException)e).getCode() == code;
    }
}

