/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.hdfs.PathUtils;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsPredicateOperand;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OnGoingSubTreeOpsClusterj
implements TablesDef.OnGoingSubTreeOpsDef,
OngoingSubTreeOpsDataAccess<SubTreeOperation> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<SubTreeOperation> removed, Collection<SubTreeOperation> newed, Collection<SubTreeOperation> modified) throws StorageException {
        ArrayList<OnGoingSubTreeOpsDTO> changes = new ArrayList<OnGoingSubTreeOpsDTO>();
        ArrayList<OnGoingSubTreeOpsDTO> deletions = new ArrayList<OnGoingSubTreeOpsDTO>();
        HopsSession dbSession = this.connector.obtainSession();
        try {
            OnGoingSubTreeOpsDTO lTable;
            for (SubTreeOperation ops : newed) {
                lTable = dbSession.newInstance(OnGoingSubTreeOpsDTO.class);
                this.createPersistableSubTreeOp(ops, lTable);
                changes.add(lTable);
            }
            for (SubTreeOperation ops : modified) {
                lTable = dbSession.newInstance(OnGoingSubTreeOpsDTO.class);
                this.createPersistableSubTreeOp(ops, lTable);
                changes.add(lTable);
            }
            for (SubTreeOperation ops : removed) {
                Object[] key = new Object[]{OnGoingSubTreeOpsClusterj.getHash(ops.getPath()), ops.getPath()};
                OnGoingSubTreeOpsDTO opsTable = dbSession.newInstance(OnGoingSubTreeOpsDTO.class, key);
                deletions.add(opsTable);
            }
            if (!deletions.isEmpty()) {
                dbSession.deletePersistentAll(deletions);
            }
            if (!changes.isEmpty()) {
                dbSession.savePersistentAll(changes);
            }
        }
        finally {
            dbSession.release(deletions);
            dbSession.release(changes);
        }
    }

    public Collection<SubTreeOperation> allOps() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<OnGoingSubTreeOpsDTO> query = session.createQuery(qb.createQueryDefinition(OnGoingSubTreeOpsDTO.class));
        return this.convertAndRelease(session, query.getResultList());
    }

    public Collection<SubTreeOperation> allOpsByNN(long nnID) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<OnGoingSubTreeOpsDTO> dobj = qb.createQueryDefinition(OnGoingSubTreeOpsDTO.class);
        HopsPredicate pred = dobj.get("namenodeId").equal(dobj.param("namenodeIdParam"));
        dobj.where(pred);
        HopsQuery<OnGoingSubTreeOpsDTO> query = dbSession.createQuery(dobj);
        query.setParameter("namenodeIdParam", nnID);
        return this.convertAndRelease(dbSession, query.getResultList());
    }

    public Collection<SubTreeOperation> findByPathsByPrefix(String prefix) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<OnGoingSubTreeOpsDTO> dobj = qb.createQueryDefinition(OnGoingSubTreeOpsDTO.class);
        HopsPredicate pred = dobj.get("partitionId").equal(dobj.param("partitionIDParam"));
        HopsPredicateOperand propertyPredicate = dobj.get("path");
        HopsPredicateOperand propertyLimit = dobj.param("prefix");
        HopsPredicate like = propertyPredicate.like(propertyLimit);
        dobj.where(pred.and(like));
        HopsQuery<OnGoingSubTreeOpsDTO> query = dbSession.createQuery(dobj);
        query.setParameter("partitionIDParam", OnGoingSubTreeOpsClusterj.getHash(prefix));
        query.setParameter("prefix", prefix + "%");
        return this.convertAndRelease(dbSession, query.getResultList());
    }

    private List<SubTreeOperation> convertAndRelease(HopsSession session, Collection<OnGoingSubTreeOpsDTO> dtos) throws StorageException {
        ArrayList<SubTreeOperation> list = new ArrayList<SubTreeOperation>();
        for (OnGoingSubTreeOpsDTO dto : dtos) {
            list.add(this.convertAndRelease(session, dto));
        }
        return list;
    }

    private SubTreeOperation convertAndRelease(HopsSession session, OnGoingSubTreeOpsDTO opsDto) throws StorageException {
        SubTreeOperation subTreeOperation = new SubTreeOperation(opsDto.getPath(), opsDto.getNamenodeId(), SubTreeOperation.Type.values()[opsDto.getOpName()]);
        session.release(opsDto);
        return subTreeOperation;
    }

    private void createPersistableSubTreeOp(SubTreeOperation op, OnGoingSubTreeOpsDTO opDto) {
        opDto.setPath(op.getPath());
        opDto.setPartitionId(OnGoingSubTreeOpsClusterj.getHash(op.getPath()));
        opDto.setNamenodeId(op.getNameNodeId());
        opDto.setOpName(op.getOpType().ordinal());
    }

    private static int getHash(String path) {
        String[] pathComponents = PathUtils.getPathNames(path);
        if (pathComponents.length <= 1) {
            throw new UnsupportedOperationException("Taking sub tree lock on the root is not yet supported ");
        }
        return pathComponents[1].hashCode();
    }

    @PersistenceCapable(table="hdfs_on_going_sub_tree_ops")
    @PartitionKey(column="partition_id")
    public static interface OnGoingSubTreeOpsDTO {
        @PrimaryKey
        @Column(name="path")
        public String getPath();

        public void setPath(String var1);

        @PrimaryKey
        @Column(name="partition_id")
        public int getPartitionId();

        public void setPartitionId(int var1);

        @Column(name="namenode_id")
        public long getNamenodeId();

        public void setNamenodeId(long var1);

        @Column(name="op_name")
        public int getOpName();

        public void setOpName(int var1);
    }
}

