/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.ContainerIdToCleanDataAccess;
import io.hops.metadata.yarn.entity.ContainerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContainerIdToCleanClusterJ
implements TablesDef.ContainerIdToCleanTableDef,
ContainerIdToCleanDataAccess<ContainerId> {
    private static final Log LOG = LogFactory.getLog(ContainerIdToCleanClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<ContainerId> findByRMNode(String rmnodeId) throws StorageException {
        LOG.debug((Object)("HOP :: ClusterJ ContainerIdToClean.findByRMNode - START:" + rmnodeId));
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerIdToCleanDTO> dobj = qb.createQueryDefinition(ContainerIdToCleanDTO.class);
        HopsPredicate pred = dobj.get("rmnodeid").equal(dobj.param("rmnodeid"));
        dobj.where(pred);
        HopsQuery<ContainerIdToCleanDTO> query = session.createQuery(dobj);
        query.setParameter("rmnodeid", rmnodeId);
        List<ContainerIdToCleanDTO> queryResults = query.getResultList();
        LOG.debug((Object)("HOP :: ClusterJ ContainerIdToClean.findByRMNode - FINISH:" + rmnodeId));
        if (queryResults != null && !queryResults.isEmpty()) {
            List<ContainerId> results = this.createContainersToCleanList(queryResults);
            session.release(queryResults);
            return results;
        }
        return null;
    }

    public Map<String, Set<ContainerId>> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ ContainerIdToClean.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerIdToCleanDTO> dobj = qb.createQueryDefinition(ContainerIdToCleanDTO.class);
        HopsQuery<ContainerIdToCleanDTO> query = session.createQuery(dobj);
        List<ContainerIdToCleanDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ ContainerIdToClean.findByRMNode - FINISH");
        Map<String, Set<ContainerId>> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(Collection<ContainerId> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerIdToCleanDTO> toModify = new ArrayList<ContainerIdToCleanDTO>();
        for (ContainerId hop : containers) {
            toModify.add(this.createPersistable(hop, session));
        }
        session.savePersistentAll(toModify);
        session.release(toModify);
    }

    public void add(ContainerId container) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ContainerIdToCleanDTO toPersist = this.createPersistable(container, session);
        session.savePersistent(toPersist);
        session.release(toPersist);
    }

    public void removeAll(Collection<ContainerId> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerIdToCleanDTO> toRemove = new ArrayList<ContainerIdToCleanDTO>();
        for (ContainerId hop : containers) {
            toRemove.add(this.createPersistable(hop, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    private ContainerIdToCleanDTO createPersistable(ContainerId hop, HopsSession session) throws StorageException {
        ContainerIdToCleanDTO dto = session.newInstance(ContainerIdToCleanDTO.class);
        dto.setrmnodeid(hop.getRmnodeid());
        dto.setcontainerid(hop.getContainerId());
        return dto;
    }

    private ContainerId createHopContainerIdToClean(ContainerIdToCleanDTO dto) {
        ContainerId hop = new ContainerId(dto.getrmnodeid(), dto.getcontainerid());
        return hop;
    }

    private List<ContainerId> createContainersToCleanList(List<ContainerIdToCleanDTO> results) {
        ArrayList<ContainerId> containersToClean = new ArrayList<ContainerId>();
        for (ContainerIdToCleanDTO persistable : results) {
            containersToClean.add(this.createHopContainerIdToClean(persistable));
        }
        return containersToClean;
    }

    private Map<String, Set<ContainerId>> createMap(List<ContainerIdToCleanDTO> results) {
        HashMap<String, Set<ContainerId>> map = new HashMap<String, Set<ContainerId>>();
        for (ContainerIdToCleanDTO dto : results) {
            ContainerId hop = this.createHopContainerIdToClean(dto);
            if (map.get(hop.getRmnodeid()) == null) {
                map.put(hop.getRmnodeid(), new HashSet());
            }
            ((Set)map.get(hop.getRmnodeid())).add(hop);
        }
        return map;
    }

    @PersistenceCapable(table="yarn_containerid_toclean")
    public static interface ContainerIdToCleanDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getrmnodeid();

        public void setrmnodeid(String var1);

        @PrimaryKey
        @Column(name="containerid")
        public String getcontainerid();

        public void setcontainerid(String var1);
    }
}

