/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.election;

import com.mysql.clusterj.annotation.PartitionKey;
import io.hops.exception.StorageException;
import io.hops.metadata.election.TablesDef;
import io.hops.metadata.election.dal.LeDescriptorDataAccess;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class LeDescriptorClusterj
implements TablesDef.LeDescriptorTableDef,
LeDescriptorDataAccess<LeDescriptor> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    @PartitionKey(column="partition_val")
    Class dto;

    public LeDescriptorClusterj(Class dto) {
        this.dto = dto;
    }

    public LeDescriptor findByPkey(long id, int partitionKey) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        Object[] keys = new Object[]{partitionKey, id};
        LeaderDTO lTable = (LeaderDTO)dbSession.find(this.dto, keys);
        if (lTable != null) {
            LeDescriptor leader = this.createDescriptor(lTable);
            return leader;
        }
        return null;
    }

    public Collection<LeDescriptor> findAll() throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType dobj = qb.createQueryDefinition(this.dto);
        HopsQuery query = dbSession.createQuery(dobj);
        return this.createList(query.getResultList());
    }

    public void prepare(Collection<LeDescriptor> removed, Collection<LeDescriptor> newed, Collection<LeDescriptor> modified) throws StorageException {
        LeaderDTO lTable;
        HopsSession dbSession = this.connector.obtainSession();
        ArrayList<LeaderDTO> changes = new ArrayList<LeaderDTO>();
        ArrayList<LeaderDTO> deletions = new ArrayList<LeaderDTO>();
        for (LeDescriptor l : newed) {
            lTable = (LeaderDTO)dbSession.newInstance(this.dto);
            this.createPersistableLeaderInstance(l, lTable);
            changes.add(lTable);
        }
        for (LeDescriptor l : modified) {
            lTable = (LeaderDTO)dbSession.newInstance(this.dto);
            this.createPersistableLeaderInstance(l, lTable);
            changes.add(lTable);
        }
        for (LeDescriptor l : removed) {
            lTable = (LeaderDTO)dbSession.newInstance(this.dto);
            this.createPersistableLeaderInstance(l, lTable);
            deletions.add(lTable);
        }
        dbSession.deletePersistentAll(deletions);
        dbSession.savePersistentAll(changes);
    }

    private Collection<LeDescriptor> createList(List<LeaderDTO> list) {
        ArrayList<LeDescriptor> listRet = new ArrayList<LeDescriptor>(list.size());
        for (LeaderDTO dto : list) {
            listRet.add(this.createDescriptor(dto));
        }
        return listRet;
    }

    protected abstract LeDescriptor createDescriptor(LeaderDTO var1);

    private void createPersistableLeaderInstance(LeDescriptor leader, LeaderDTO lTable) {
        lTable.setId(leader.getId());
        lTable.setCounter(leader.getCounter());
        lTable.setHostname(leader.getRpcAddresses());
        lTable.setHttpAddress(leader.getHttpAddress());
        lTable.setPartitionVal(leader.getPartitionVal());
        lTable.setLocationDomainId(leader.getLocationDomainId());
    }

    public static interface LeaderDTO {
        public long getId();

        public void setId(long var1);

        public int getPartitionVal();

        public void setPartitionVal(int var1);

        public long getCounter();

        public void setCounter(long var1);

        public String getHostname();

        public void setHostname(String var1);

        public String getHttpAddress();

        public void setHttpAddress(String var1);

        public byte getLocationDomainId();

        public void setLocationDomainId(byte var1);
    }
}

