/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.entity.BlockInfo;
import io.hops.metadata.hdfs.entity.BlockLookUp;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.hdfs.BlockLookUpClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.ReplicaClusterj;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BlockInfoClusterj
implements TablesDef.BlockInfoTableDef,
BlockInfoDataAccess<BlockInfo> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private static final int NOT_FOUND_ROW = -1000;

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_block_infos");
    }

    public int countAllCompleteBlocks() throws StorageException {
        return MySQLQueryHelper.countWithCriterion("hdfs_block_infos", String.format("%s=%d", "block_under_construction_state", 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<BlockInfo> removed, Collection<BlockInfo> news, Collection<BlockInfo> modified) throws StorageException {
        ArrayList<BlockInfoDTO> blkChanges = new ArrayList<BlockInfoDTO>();
        ArrayList<BlockInfoDTO> blkDeletions = new ArrayList<BlockInfoDTO>();
        ArrayList<BlockLookUpClusterj.BlockLookUpDTO> luChanges = new ArrayList<BlockLookUpClusterj.BlockLookUpDTO>();
        ArrayList<BlockLookUpClusterj.BlockLookUpDTO> luDeletions = new ArrayList<BlockLookUpClusterj.BlockLookUpDTO>();
        HopsSession session = this.connector.obtainSession();
        try {
            BlockLookUpClusterj.BlockLookUpDTO lookupDTO;
            BlockInfoDTO bTable;
            for (BlockInfo block : removed) {
                Object[] pk = new Object[]{block.getInodeId(), block.getBlockId()};
                BlockInfoDTO bTable2 = session.newInstance(BlockInfoDTO.class, pk);
                blkDeletions.add(bTable2);
                BlockLookUpClusterj.BlockLookUpDTO lookupDTO2 = session.newInstance(BlockLookUpClusterj.BlockLookUpDTO.class, block.getBlockId());
                luDeletions.add(lookupDTO2);
            }
            for (BlockInfo block : news) {
                bTable = session.newInstance(BlockInfoDTO.class);
                this.createPersistable(block, bTable);
                blkChanges.add(bTable);
                lookupDTO = session.newInstance(BlockLookUpClusterj.BlockLookUpDTO.class);
                BlockLookUpClusterj.createPersistable(new BlockLookUp(block.getBlockId(), block.getInodeId()), lookupDTO);
                luChanges.add(lookupDTO);
            }
            for (BlockInfo block : modified) {
                bTable = session.newInstance(BlockInfoDTO.class);
                this.createPersistable(block, bTable);
                blkChanges.add(bTable);
                lookupDTO = session.newInstance(BlockLookUpClusterj.BlockLookUpDTO.class);
                BlockLookUpClusterj.createPersistable(new BlockLookUp(block.getBlockId(), block.getInodeId()), lookupDTO);
                luChanges.add(lookupDTO);
            }
            session.deletePersistentAll(blkDeletions);
            session.deletePersistentAll(luDeletions);
            session.savePersistentAll(blkChanges);
            session.savePersistentAll(luChanges);
        }
        finally {
            session.release(blkDeletions);
            session.release(luDeletions);
            session.release(blkChanges);
            session.release(luChanges);
        }
    }

    public BlockInfo findById(long blockId, long inodeId) throws StorageException {
        Object[] pk = new Object[]{inodeId, blockId};
        HopsSession session = this.connector.obtainSession();
        BlockInfoDTO bit = session.find(BlockInfoDTO.class, pk);
        if (bit == null) {
            return null;
        }
        BlockInfo bi = this.createBlockInfo(bit);
        session.release(bit);
        return bi;
    }

    public List<BlockInfo> findByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<BlockInfoDTO> dobj = qb.createQueryDefinition(BlockInfoDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("iNodeParam"));
        dobj.where(pred1);
        HopsQuery<BlockInfoDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeParam", inodeId);
        List<BlockInfoDTO> dtos = query.getResultList();
        List<BlockInfo> lbis = this.createBlockInfoList(dtos);
        session.release(dtos);
        return lbis;
    }

    public List<BlockInfo> findByInodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<BlockInfoDTO> dobj = qb.createQueryDefinition(BlockInfoDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").in(dobj.param("iNodeParam"));
        dobj.where(pred1);
        HopsQuery<BlockInfoDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeParam", Longs.asList((long[])inodeIds));
        List<BlockInfoDTO> biDtos = query.getResultList();
        List<BlockInfo> lbis = this.createBlockInfoList(biDtos);
        session.release(biDtos);
        return lbis;
    }

    public BlockInfo scanByBlockId(long blockId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<BlockInfoDTO> dobj = qb.createQueryDefinition(BlockInfoDTO.class);
        HopsPredicate pred1 = dobj.get("blockId").equal(dobj.param("blockIdParam"));
        dobj.where(pred1);
        HopsQuery<BlockInfoDTO> query = session.createQuery(dobj);
        query.setParameter("blockIdParam", blockId);
        List<BlockInfoDTO> biDtos = query.getResultList();
        BlockInfo bi = this.createBlockInfo(biDtos.get(0));
        session.release(biDtos);
        return bi;
    }

    public List<BlockInfo> findAllBlocks() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<BlockInfoDTO> dobj = qb.createQueryDefinition(BlockInfoDTO.class);
        HopsQuery<BlockInfoDTO> query = session.createQuery(dobj);
        List<BlockInfoDTO> biDtos = query.getResultList();
        List<BlockInfo> lbis = this.createBlockInfoList(biDtos);
        session.release(biDtos);
        return lbis;
    }

    public List<BlockInfo> findBlockInfosByStorageId(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<ReplicaClusterj.ReplicaDTO> replicas = ReplicaClusterj.getReplicas(session, storageId);
        long[] blockIds = new long[replicas.size()];
        long[] inodeIds = new long[replicas.size()];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = replicas.get(i).getBlockId();
            inodeIds[i] = replicas.get(i).getINodeId();
        }
        List<BlockInfo> ret = this.readBlockInfoBatch(session, inodeIds, blockIds);
        session.release(replicas);
        return ret;
    }

    public List<BlockInfo> findBlockInfosByStorageId(int storageId, long from, int size) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<ReplicaClusterj.ReplicaDTO> replicas = ReplicaClusterj.getReplicas(session, storageId, from, size);
        long[] blockIds = new long[replicas.size()];
        long[] inodeIds = new long[replicas.size()];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = replicas.get(i).getBlockId();
            inodeIds[i] = replicas.get(i).getINodeId();
        }
        List<BlockInfo> ret = this.readBlockInfoBatch(session, inodeIds, blockIds);
        session.release(replicas);
        return ret;
    }

    public List<BlockInfo> findBlockInfosBySids(List<Integer> sids) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaClusterj.ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaClusterj.ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("storageId").in(dobj.param("sids"));
        dobj.where(pred1);
        HopsQuery<ReplicaClusterj.ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("sids", sids);
        List<ReplicaClusterj.ReplicaDTO> replicas = query.getResultList();
        long[] blockIds = new long[replicas.size()];
        long[] inodeIds = new long[replicas.size()];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = replicas.get(i).getBlockId();
            inodeIds[i] = replicas.get(i).getINodeId();
        }
        List<BlockInfo> ret = this.readBlockInfoBatch(session, inodeIds, blockIds);
        session.release(replicas);
        return ret;
    }

    public Set<Long> findINodeIdsByStorageId(int storageId) throws StorageException {
        return ReplicaClusterj.getReplicas(storageId);
    }

    public List<BlockInfo> findByIds(long[] blockIds, long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<BlockInfo> blks = this.readBlockInfoBatch(session, inodeIds, blockIds);
        return blks;
    }

    public boolean existsOnAnyStorage(long inodeId, long blockId, List<Integer> sids) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ReplicaClusterj.ReplicaDTO> dtos = new ArrayList<ReplicaClusterj.ReplicaDTO>();
        for (Integer sid : sids) {
            Object[] pk = new Object[]{inodeId, blockId, sid};
            ReplicaClusterj.ReplicaDTO dto = session.newInstance(ReplicaClusterj.ReplicaDTO.class, pk);
            dto.setBucketId(-1000);
            dto = session.load(dto);
            dtos.add(dto);
        }
        session.flush();
        boolean exist = false;
        for (ReplicaClusterj.ReplicaDTO dto : dtos) {
            if (dto.getBucketId() == -1000) continue;
            exist = true;
            break;
        }
        session.release(dtos);
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BlockInfo> readBlockInfoBatch(HopsSession session, long[] inodeIds, long[] blockIds) throws StorageException {
        ArrayList<BlockInfoDTO> bdtos = new ArrayList<BlockInfoDTO>();
        try {
            List<BlockInfo> lbis;
            for (int i = 0; i < blockIds.length; ++i) {
                Object[] pk = new Object[]{inodeIds[i], blockIds[i]};
                BlockInfoDTO bdto = session.newInstance(BlockInfoDTO.class, pk);
                bdto.setBlockIndex(-1000);
                bdto = session.load(bdto);
                bdtos.add(bdto);
            }
            session.flush();
            List<BlockInfo> list = lbis = this.createBlockInfoList(bdtos);
            return list;
        }
        finally {
            session.release(bdtos);
        }
    }

    private List<BlockInfo> createBlockInfoList(List<BlockInfoDTO> bitList) {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        if (bitList != null) {
            for (BlockInfoDTO blockInfoDTO : bitList) {
                if (blockInfoDTO.getBlockIndex() == -1000) continue;
                list.add(this.createBlockInfo(blockInfoDTO));
            }
        }
        return list;
    }

    private BlockInfo createBlockInfo(BlockInfoDTO bDTO) {
        BlockInfo hopBlockInfo = new BlockInfo(bDTO.getBlockId(), bDTO.getBlockIndex(), bDTO.getINodeId(), bDTO.getNumBytes(), bDTO.getGenerationStamp(), bDTO.getBlockUCState(), bDTO.getTimestamp(), bDTO.getPrimaryNodeIndex(), bDTO.getBlockRecoveryId(), bDTO.getTruncateBlockNumBytes(), bDTO.getTruncateBlockGenerationBlock());
        return hopBlockInfo;
    }

    private void createPersistable(BlockInfo block, BlockInfoDTO persistable) {
        persistable.setBlockId(block.getBlockId());
        persistable.setNumBytes(block.getNumBytes());
        persistable.setGenerationStamp(block.getGenerationStamp());
        persistable.setINodeId(block.getInodeId());
        persistable.setTimestamp(block.getTimeStamp());
        persistable.setBlockIndex(block.getBlockIndex());
        persistable.setBlockUCState(block.getBlockUCState());
        persistable.setPrimaryNodeIndex(block.getPrimaryNodeIndex());
        persistable.setBlockRecoveryId(block.getBlockRecoveryId());
        persistable.setTruncateBlockNumBytes(block.getTruncateBlockNumBytes());
        persistable.setTruncateBlockGenerationBlock(block.getTruncateBlockGenerationStamp());
    }

    @PersistenceCapable(table="hdfs_block_infos")
    @PartitionKey(column="inode_id")
    public static interface BlockInfoDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @Column(name="block_index")
        public int getBlockIndex();

        public void setBlockIndex(int var1);

        @Column(name="num_bytes")
        public long getNumBytes();

        public void setNumBytes(long var1);

        @Column(name="generation_stamp")
        public long getGenerationStamp();

        public void setGenerationStamp(long var1);

        @Column(name="block_under_construction_state")
        public int getBlockUCState();

        public void setBlockUCState(int var1);

        @Column(name="time_stamp")
        public long getTimestamp();

        public void setTimestamp(long var1);

        @Column(name="primary_node_index")
        public int getPrimaryNodeIndex();

        public void setPrimaryNodeIndex(int var1);

        @Column(name="block_recovery_id")
        public long getBlockRecoveryId();

        public void setBlockRecoveryId(long var1);

        @Column(name="truncate_block_num_bytes")
        public long getTruncateBlockNumBytes();

        public void setTruncateBlockNumBytes(long var1);

        @Column(name="truncate_block_generation_stamp")
        public long getTruncateBlockGenerationBlock();

        public void setTruncateBlockGenerationBlock(long var1);
    }
}

