/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.metadata.hdfs.entity.CacheDirective;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.hdfs.CacheDirectivePathClusterj;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CacheDirectiveClusterj
implements TablesDef.CacheDirectiveTableDef,
CacheDirectiveDataAccess<CacheDirective> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private CacheDirectivePathClusterj pathDA = new CacheDirectivePathClusterj();

    public CacheDirective find(long key) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        CacheDirectiveDTO result = session.find(CacheDirectiveDTO.class, key);
        if (result != null) {
            CacheDirective retryCacheEntry = this.convert(result);
            session.release(result);
            return retryCacheEntry;
        }
        return null;
    }

    public Collection<CacheDirective> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CacheDirectiveDTO> dobj = qb.createQueryDefinition(CacheDirectiveDTO.class);
        HopsQuery<CacheDirectiveDTO> query = session.createQuery(dobj);
        List<CacheDirectiveDTO> dtos = query.getResultList();
        Collection<CacheDirective> directives = this.convert(dtos);
        session.release(dtos);
        return directives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheDirective> findByPool(String pool) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CacheDirectiveDTO> dobj = qb.createQueryDefinition(CacheDirectiveDTO.class);
        HopsPredicate pred1 = dobj.get("pool").equal(dobj.param("pool"));
        dobj.where(pred1);
        HopsQuery<CacheDirectiveDTO> query = session.createQuery(dobj);
        query.setParameter("pool", pool);
        List<CacheDirectiveDTO> results = null;
        try {
            results = query.getResultList();
            if (results == null) {
                Collection<CacheDirective> collection = null;
                return collection;
            }
            Collection<CacheDirective> collection = this.convert(results);
            return collection;
        }
        finally {
            session.release(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheDirective> findByIdAndPool(long id, String pool) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CacheDirectiveDTO> dobj = qb.createQueryDefinition(CacheDirectiveDTO.class);
        HopsPredicate pred1 = dobj.get("id").greaterEqual(dobj.param("id"));
        if (pool != null) {
            HopsPredicate pred2 = dobj.get("pool").equal(dobj.param("pool"));
            pred1 = pred1.and(pred2);
        }
        dobj.where(pred1);
        HopsQuery<CacheDirectiveDTO> query = session.createQuery(dobj);
        query.setParameter("id", id);
        if (pool != null) {
            query.setParameter("pool", pool);
        }
        List<CacheDirectiveDTO> results = null;
        try {
            results = query.getResultList();
            if (results == null) {
                Collection<CacheDirective> collection = null;
                return collection;
            }
            Collection<CacheDirective> collection = this.convert(results);
            return collection;
        }
        finally {
            session.release(results);
        }
    }

    public void prepare(Collection<CacheDirective> removed, Collection<CacheDirective> modified) throws StorageException {
        CacheDirectiveDTO newInstance;
        ArrayList<CacheDirectiveDTO> changes = new ArrayList<CacheDirectiveDTO>();
        ArrayList<CacheDirectiveDTO> deletions = new ArrayList<CacheDirectiveDTO>();
        HashMap<Long, String> pathToAdd = new HashMap<Long, String>(modified.size());
        HopsSession session = this.connector.obtainSession();
        for (CacheDirective cacheDirective : removed) {
            newInstance = session.newInstance(CacheDirectiveDTO.class);
            this.createPersistable(cacheDirective, newInstance);
            deletions.add(newInstance);
        }
        for (CacheDirective cacheDirective : modified) {
            newInstance = session.newInstance(CacheDirectiveDTO.class);
            this.createPersistable(cacheDirective, newInstance);
            changes.add(newInstance);
            pathToAdd.put(cacheDirective.getId(), cacheDirective.getPath());
        }
        session.deletePersistentAll(deletions);
        session.savePersistentAll(changes);
        session.release(deletions);
        session.release(changes);
        this.pathDA.add(pathToAdd);
    }

    private Collection<CacheDirective> convert(List<CacheDirectiveDTO> dtos) throws StorageException {
        ArrayList<CacheDirective> result = new ArrayList<CacheDirective>(dtos.size());
        for (CacheDirectiveDTO dto : dtos) {
            result.add(this.convert(dto));
        }
        return result;
    }

    private CacheDirective convert(CacheDirectiveDTO result) throws StorageException {
        return new CacheDirective(Long.valueOf(result.getId()), this.pathDA.find(result.getId()), result.getReplication(), result.getExpiryTime(), result.getBytesNeeded(), result.getBytesCached(), result.getFilesNeeded(), result.getFilesCached(), result.getPool());
    }

    private void createPersistable(CacheDirective cacheDirective, CacheDirectiveDTO newInstance) {
        newInstance.setId(cacheDirective.getId());
        newInstance.setBytesCached(cacheDirective.getBytesCached());
        newInstance.setBytesNeeded(cacheDirective.getBytesNeeded());
        newInstance.setExpiryTime(cacheDirective.getExpiryTime());
        newInstance.setFilesCached(cacheDirective.getFilesCached());
        newInstance.setFilesNeeded(cacheDirective.getFilesNeeded());
        newInstance.setPool(cacheDirective.getPool());
        newInstance.setReplication(cacheDirective.getReplication());
    }

    @PersistenceCapable(table="hdfs_cache_directive")
    public static interface CacheDirectiveDTO {
        @PrimaryKey
        @Column(name="id")
        public long getId();

        public void setId(long var1);

        @Column(name="replication")
        public short getReplication();

        public void setReplication(short var1);

        @Column(name="expirytime")
        public long getExpiryTime();

        public void setExpiryTime(long var1);

        @Column(name="bytes_needed")
        public long getBytesNeeded();

        public void setBytesNeeded(long var1);

        @Column(name="bytes_cached")
        public long getBytesCached();

        public void setBytesCached(long var1);

        @Column(name="files_needed")
        public long getFilesNeeded();

        public void setFilesNeeded(long var1);

        @Column(name="files_cached")
        public long getFilesCached();

        public void setFilesCached(long var1);

        @Column(name="pool")
        public String getPool();

        public void setPool(String var1);
    }
}

