/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.EncodingJobsDataAccess;
import io.hops.metadata.hdfs.entity.EncodingJob;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncodingJobsClusterj
implements TablesDef.EncodingJobsTableDef,
EncodingJobsDataAccess<EncodingJob> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EncodingJob encodingJob) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        EncodingJobDto dto = null;
        try {
            dto = this.createPersistable(encodingJob);
            session.makePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(EncodingJob encodingJob) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        EncodingJobDto dto = null;
        try {
            dto = this.createPersistable(encodingJob);
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    public Collection<EncodingJob> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<EncodingJobDto> dobj = qb.createQueryDefinition(EncodingJobDto.class);
        HopsQuery<EncodingJobDto> query = session.createQuery(dobj);
        List<EncodingJobDto> dtos = query.getResultList();
        List<EncodingJob> ivl = this.createList(dtos);
        session.release(dtos);
        return ivl;
    }

    private EncodingJobDto createPersistable(EncodingJob encodingJob) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        EncodingJobDto dto = session.newInstance(EncodingJobDto.class);
        dto.setJtidentifier(encodingJob.getJtIdentifier());
        dto.setJobId(encodingJob.getJobId());
        dto.setPath(encodingJob.getPath());
        dto.setJobDir(encodingJob.getJobDir());
        return dto;
    }

    private EncodingJob create(EncodingJobDto dto) {
        EncodingJob job = new EncodingJob();
        job.setJtIdentifier(dto.getJtidentifier());
        job.setJobId(dto.getJobId());
        job.setPath(dto.getPath());
        job.setJobDir(dto.getJobDir());
        return job;
    }

    private List<EncodingJob> createList(List<EncodingJobDto> dtos) {
        ArrayList<EncodingJob> list = new ArrayList<EncodingJob>(dtos.size());
        for (EncodingJobDto dto : dtos) {
            list.add(this.create(dto));
        }
        return list;
    }

    @PersistenceCapable(table="hdfs_encoding_jobs")
    public static interface EncodingJobDto {
        @PrimaryKey
        @Column(name="jt_identifier")
        public String getJtidentifier();

        public void setJtidentifier(String var1);

        @PrimaryKey
        @Column(name="job_id")
        public int getJobId();

        public void setJobId(int var1);

        @Column(name="path")
        public String getPath();

        public void setPath(String var1);

        @Column(name="job_dir")
        public String getJobDir();

        public void setJobDir(String var1);
    }
}

