/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Lists;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.entity.Group;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupClusterj
implements TablesDef.GroupsTableDef,
GroupDataAccess<Group> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public Group getGroup(int groupId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        GroupDTO dto = session.find(GroupDTO.class, groupId);
        Group group = null;
        if (dto != null) {
            group = new Group(dto.getId(), dto.getName());
            session.release(dto);
        }
        return group;
    }

    public Group getGroup(String groupName) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        return this.getGroup(session, groupName);
    }

    public Group addGroup(String groupName) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Group group = this.getGroup(session, groupName);
        if (group == null) {
            this.addGroup(session, groupName);
            session.flush();
            group = this.getGroup(session, groupName);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(int groupId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        GroupDTO dto = null;
        try {
            dto = session.newInstance(GroupDTO.class, groupId);
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    static List<Group> convert(HopsSession session, Collection<GroupDTO> dtos) throws StorageException {
        ArrayList groups = Lists.newArrayListWithExpectedSize((int)dtos.size());
        for (GroupDTO dto : dtos) {
            groups.add(new Group(dto.getId(), dto.getName()));
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroup(HopsSession session, String groupName) throws StorageException {
        GroupDTO dto = null;
        try {
            dto = session.newInstance(GroupDTO.class);
            dto.setName(groupName);
            session.makePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    private Group getGroup(HopsSession session, String groupName) throws StorageException {
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<GroupDTO> dobj = qb.createQueryDefinition(GroupDTO.class);
        dobj.where(dobj.get("name").equal(dobj.param("param")));
        HopsQuery<GroupDTO> query = session.createQuery(dobj);
        query.setParameter("param", groupName);
        List<GroupDTO> results = query.getResultList();
        Group group = null;
        if (results.size() == 1) {
            group = new Group(results.get(0).getId(), results.get(0).getName());
        }
        session.release(results);
        return group;
    }

    @PersistenceCapable(table="hdfs_groups")
    public static interface GroupDTO {
        @PrimaryKey
        @Column(name="id")
        public int getId();

        public void setId(int var1);

        @Column(name="name")
        public String getName();

        public void setName(String var1);
    }
}

