/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HashBucketClusterj
implements TablesDef.HashBucketsTableDef,
HashBucketDataAccess<HashBucket> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public HashBucket findBucket(int storageId, int bucketId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{storageId, bucketId};
        HashBucketDTO result = session.find(HashBucketDTO.class, pk);
        if (result != null) {
            HashBucket hashBucket = this.convert(result);
            session.release(result);
            return hashBucket;
        }
        return null;
    }

    public Collection<HashBucket> findBucketsByStorageId(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<HashBucketDTO> dobj = qb.createQueryDefinition(HashBucketDTO.class);
        HopsPredicate pred1 = dobj.get("storageId").equal(dobj.param("storageIdParam"));
        dobj.where(pred1);
        HopsQuery<HashBucketDTO> query = session.createQuery(dobj);
        query.setParameter("storageIdParam", storageId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public void prepare(Collection<HashBucket> removed, Collection<HashBucket> modified) throws StorageException {
        HashBucketDTO newInstance;
        ArrayList<HashBucketDTO> changes = new ArrayList<HashBucketDTO>();
        ArrayList<HashBucketDTO> deletions = new ArrayList<HashBucketDTO>();
        HopsSession session = this.connector.obtainSession();
        for (HashBucket hashBucket : removed) {
            newInstance = session.newInstance(HashBucketDTO.class);
            this.createPersistable(hashBucket, newInstance);
            deletions.add(newInstance);
        }
        for (HashBucket hashBucket : modified) {
            newInstance = session.newInstance(HashBucketDTO.class);
            this.createPersistable(hashBucket, newInstance);
            changes.add(newInstance);
        }
        session.deletePersistentAll(deletions);
        session.savePersistentAll(changes);
        session.release(deletions);
        session.release(changes);
    }

    private HashBucket convert(HashBucketDTO result) {
        return new HashBucket(result.getStorageId(), result.getBucketId(), result.getHash());
    }

    private List<HashBucket> convertAndRelease(HopsSession session, List<HashBucketDTO> triplets) throws StorageException {
        ArrayList<HashBucket> hashBuckets = new ArrayList<HashBucket>(triplets.size());
        for (HashBucketDTO t : triplets) {
            hashBuckets.add(this.convert(t));
            session.release(t);
        }
        return hashBuckets;
    }

    private void createPersistable(HashBucket hashBucket, HashBucketDTO newInstance) {
        newInstance.setStorageId(hashBucket.getStorageId());
        newInstance.setBucketId(hashBucket.getBucketId());
        newInstance.setHash(hashBucket.getHash());
    }

    @PersistenceCapable(table="hdfs_hash_buckets")
    @PartitionKey(column="storage_id")
    @Index(name="storage_idx")
    public static interface HashBucketDTO {
        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @PrimaryKey
        @Column(name="bucket_id")
        public int getBucketId();

        public void setBucketId(int var1);

        @Column(name="hash")
        public byte[] getHash();

        public void setHash(byte[] var1);
    }
}

