/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.LeaseDataAccess;
import io.hops.metadata.hdfs.entity.Lease;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsPredicateOperand;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeaseClusterj
implements TablesDef.LeaseTableDef,
LeaseDataAccess<Lease> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private static Log log = LogFactory.getLog(LeaseDataAccess.class);

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_leases");
    }

    public Lease findByPKey(String holder, int holderId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] key = new Object[]{holderId, holder};
        LeaseDTO lTable = session.find(LeaseDTO.class, key);
        if (lTable != null) {
            Lease lease = this.createLease(lTable);
            session.release(lTable);
            return lease;
        }
        return null;
    }

    public Lease findByHolderId(int holderId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<LeaseDTO> dobj = qb.createQueryDefinition(LeaseDTO.class);
        HopsPredicate pred1 = dobj.get("holderId").equal(dobj.param("param1"));
        dobj.where(pred1);
        HopsQuery<LeaseDTO> query = session.createQuery(dobj);
        query.setParameter("param1", holderId);
        List<LeaseDTO> leaseTables = query.getResultList();
        if (leaseTables.size() > 1) {
            log.error((Object)"Error in selectLeaseTableInternal: Multiple rows with same holderID");
            session.release(leaseTables);
            return null;
        }
        if (leaseTables.size() == 1) {
            Lease lease = this.createLease(leaseTables.get(0));
            session.release(leaseTables);
            return lease;
        }
        log.info((Object)("No rows found for holderID:" + holderId + " in Lease table"));
        return null;
    }

    public Collection<Lease> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<LeaseDTO> query = session.createQuery(qb.createQueryDefinition(LeaseDTO.class));
        List<LeaseDTO> dtos = query.getResultList();
        Collection<Lease> ll = this.createList(dtos);
        session.release(dtos);
        return ll;
    }

    public Collection<Lease> findByTimeLimit(long timeLimit) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<LeaseDTO> dobj = qb.createQueryDefinition(LeaseDTO.class);
        HopsPredicateOperand propertyPredicate = dobj.get("lastUpdate");
        String param = "timelimit";
        HopsPredicateOperand propertyLimit = dobj.param(param);
        HopsPredicate lessThan = propertyPredicate.lessThan(propertyLimit);
        dobj.where(lessThan);
        HopsQuery<LeaseDTO> query = session.createQuery(dobj);
        query.setParameter(param, timeLimit);
        List<LeaseDTO> dtos = query.getResultList();
        Collection<Lease> ll = this.createList(dtos);
        session.release(dtos);
        return ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<Lease> removed, Collection<Lease> newed, Collection<Lease> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<LeaseDTO> changes = new ArrayList<LeaseDTO>();
        ArrayList<LeaseDTO> deletions = new ArrayList<LeaseDTO>();
        try {
            LeaseDTO lTable;
            for (Lease l : newed) {
                lTable = session.newInstance(LeaseDTO.class);
                this.createPersistableLeaseInstance(l, lTable);
                changes.add(lTable);
            }
            for (Lease l : modified) {
                lTable = session.newInstance(LeaseDTO.class);
                this.createPersistableLeaseInstance(l, lTable);
                changes.add(lTable);
            }
            for (Lease l : removed) {
                Object[] key = new Object[]{l.getHolderId(), l.getHolder()};
                LeaseDTO lTable2 = session.newInstance(LeaseDTO.class, key);
                deletions.add(lTable2);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private Collection<Lease> createList(List<LeaseDTO> list) {
        ArrayList<Lease> finalSet = new ArrayList<Lease>();
        for (LeaseDTO dto : list) {
            finalSet.add(this.createLease(dto));
        }
        return finalSet;
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(LeaseDTO.class);
    }

    private Lease createLease(LeaseDTO lTable) {
        return new Lease(lTable.getHolder(), lTable.getHolderId(), lTable.getLastUpdate());
    }

    private void createPersistableLeaseInstance(Lease lease, LeaseDTO lTable) {
        lTable.setHolder(lease.getHolder());
        lTable.setHolderId(lease.getHolderId());
        lTable.setLastUpdate(lease.getLastUpdate());
    }

    @PersistenceCapable(table="hdfs_leases")
    @PartitionKey(column="holder_id")
    public static interface LeaseDTO {
        @PrimaryKey
        @Column(name="holder_id")
        public int getHolderId();

        public void setHolderId(int var1);

        @PrimaryKey
        @Column(name="holder")
        public String getHolder();

        public void setHolder(String var1);

        @Column(name="last_update")
        @Index(name="update_idx")
        public long getLastUpdate();

        public void setLastUpdate(long var1);
    }
}

