/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.ContainerToDecreaseDataAccess;
import io.hops.metadata.yarn.entity.Container;
import java.util.ArrayList;
import java.util.Collection;

public class ContainerToDecreaseClusterJ
implements TablesDef.ContainerToDecreaseTableDef,
ContainerToDecreaseDataAccess<Container> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public void addAll(Collection<Container> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerToDecreaseDTO> toModify = new ArrayList<ContainerToDecreaseDTO>();
        for (Container hop : containers) {
            toModify.add(this.createPersistable(hop, session));
        }
        session.savePersistentAll(toModify);
        session.release(toModify);
    }

    public void removeAll(Collection<Container> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerToDecreaseDTO> toRemove = new ArrayList<ContainerToDecreaseDTO>();
        for (Container hop : containers) {
            toRemove.add(this.createPersistable(hop, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    private ContainerToDecreaseDTO createPersistable(Container hop, HopsSession session) throws StorageException {
        ContainerToDecreaseDTO dto = session.newInstance(ContainerToDecreaseDTO.class);
        dto.setRmnodeid(hop.getNodeId());
        dto.setContainerid(hop.getContainerId());
        dto.setGpus(hop.getGpus());
        dto.setHttpAddress(hop.getHttpAddress());
        dto.setMemSize(hop.getMemSize());
        dto.setPriority(hop.getPriority());
        dto.setVersion(hop.getVersion());
        dto.setVirtualCores(hop.getVirtualCores());
        return dto;
    }

    @PersistenceCapable(table="yarn_container_to_decrease")
    public static interface ContainerToDecreaseDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getRmnodeid();

        public void setRmnodeid(String var1);

        @PrimaryKey
        @Column(name="containerid")
        public String getContainerid();

        public void setContainerid(String var1);

        @PrimaryKey
        @Column(name="http_address")
        public String getHttpAddress();

        public void setHttpAddress(String var1);

        @PrimaryKey
        @Column(name="priority")
        public int getPriority();

        public void setPriority(int var1);

        @PrimaryKey
        @Column(name="memory_size")
        public long getMemSize();

        public void setMemSize(long var1);

        @PrimaryKey
        @Column(name="virtual_cores")
        public int getVirtualCores();

        public void setVirtualCores(int var1);

        @PrimaryKey
        @Column(name="gpus")
        public int getGpus();

        public void setGpus(int var1);

        @PrimaryKey
        @Column(name="version")
        public int getVersion();

        public void setVersion(int var1);
    }
}

