/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.RMNodeApplicationsDataAccess;
import io.hops.metadata.yarn.entity.RMNodeApplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMNodeApplicationsClusterJ
implements TablesDef.FinishedApplicationsTableDef,
RMNodeApplicationsDataAccess<RMNodeApplication> {
    private static final Log LOG = LogFactory.getLog(RMNodeApplicationsClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<RMNodeApplication> findByRMNode(String rmnodeid) throws StorageException {
        LOG.debug((Object)("HOP :: ClusterJ FinishedApplications.findByRMNode - START:" + rmnodeid));
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<FinishedApplicationsDTO> dobj = qb.createQueryDefinition(FinishedApplicationsDTO.class);
        HopsPredicate pred1 = dobj.get("rmnodeid").equal(dobj.param("rmnodeid"));
        dobj.where(pred1);
        HopsQuery<FinishedApplicationsDTO> query = session.createQuery(dobj);
        query.setParameter("rmnodeid", rmnodeid);
        List<FinishedApplicationsDTO> results = query.getResultList();
        LOG.debug((Object)("HOP :: ClusterJ FinishedApplications.findByRMNode - FINISH:" + rmnodeid));
        if (results != null && !results.isEmpty()) {
            return this.createUpdatedContainerInfoList(results);
        }
        return null;
    }

    public Map<String, List<RMNodeApplication>> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ FinishedApplications.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<FinishedApplicationsDTO> dobj = qb.createQueryDefinition(FinishedApplicationsDTO.class);
        HopsQuery<FinishedApplicationsDTO> query = session.createQuery(dobj);
        List<FinishedApplicationsDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ FinishedApplications.getAll - FINISH");
        Map<String, List<RMNodeApplication>> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(Collection<RMNodeApplication> applications) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<FinishedApplicationsDTO> toModify = new ArrayList<FinishedApplicationsDTO>();
        for (RMNodeApplication entry : applications) {
            toModify.add(this.createPersistable(entry, session));
        }
        session.savePersistentAll(toModify);
        session.release(toModify);
    }

    public void add(RMNodeApplication application) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        FinishedApplicationsDTO toPersist = this.createPersistable(application, session);
        session.savePersistent(toPersist);
        session.release(toPersist);
    }

    public void removeAll(Collection<RMNodeApplication> applications) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<FinishedApplicationsDTO> toRemove = new ArrayList<FinishedApplicationsDTO>();
        for (RMNodeApplication entry : applications) {
            toRemove.add(this.createPersistable(entry, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    public void remove(RMNodeApplication application) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        FinishedApplicationsDTO toRemove = this.createPersistable(application, session);
        session.deletePersistent(toRemove);
        session.release(toRemove);
    }

    private RMNodeApplication createHopFinishedApplications(FinishedApplicationsDTO dto) {
        return new RMNodeApplication(dto.getrmnodeid(), dto.getapplicationid(), RMNodeApplication.RMNodeApplicationStatus.valueOf((String)dto.getStatus()));
    }

    private FinishedApplicationsDTO createPersistable(RMNodeApplication hop, HopsSession session) throws StorageException {
        FinishedApplicationsDTO dto = session.newInstance(FinishedApplicationsDTO.class);
        dto.setrmnodeid(hop.getRMNodeID());
        dto.setapplicationid(hop.getApplicationId());
        dto.setStatus(hop.getStatus().toString());
        return dto;
    }

    private List<RMNodeApplication> createUpdatedContainerInfoList(List<FinishedApplicationsDTO> list) {
        ArrayList<RMNodeApplication> finishedApps = new ArrayList<RMNodeApplication>();
        for (FinishedApplicationsDTO persistable : list) {
            finishedApps.add(this.createHopFinishedApplications(persistable));
        }
        return finishedApps;
    }

    private Map<String, List<RMNodeApplication>> createMap(List<FinishedApplicationsDTO> results) {
        HashMap<String, List<RMNodeApplication>> map = new HashMap<String, List<RMNodeApplication>>();
        for (FinishedApplicationsDTO dto : results) {
            RMNodeApplication hop = this.createHopFinishedApplications(dto);
            if (map.get(hop.getRMNodeID()) == null) {
                map.put(hop.getRMNodeID(), new ArrayList());
            }
            ((List)map.get(hop.getRMNodeID())).add(hop);
        }
        return map;
    }

    @PersistenceCapable(table="yarn_rmnode_applications")
    public static interface FinishedApplicationsDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getrmnodeid();

        public void setrmnodeid(String var1);

        @PrimaryKey
        @Column(name="applicationid")
        public String getapplicationid();

        public void setapplicationid(String var1);

        @PrimaryKey
        @Column(name="status")
        public String getStatus();

        public void setStatus(String var1);
    }
}

