/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.ResourceDataAccess;
import io.hops.metadata.yarn.entity.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceClusterJ
implements TablesDef.ResourceTableDef,
ResourceDataAccess<Resource> {
    private static final Log LOG = LogFactory.getLog(ResourceClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Resource findEntry(String id) throws StorageException {
        LOG.debug((Object)("HOP :: ClusterJ Resource.findEntry - START:" + id));
        HopsSession session = this.connector.obtainSession();
        ResourceDTO resourceDTO = session.find(ResourceDTO.class, id);
        LOG.debug((Object)("HOP :: ClusterJ Resource.findEntry - FINISH:" + id));
        Resource result = null;
        if (resourceDTO != null) {
            result = this.createHopResource(resourceDTO);
        }
        session.release(resourceDTO);
        return result;
    }

    public Map<String, Resource> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ Resource.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ResourceDTO> dobj = qb.createQueryDefinition(ResourceDTO.class);
        HopsQuery<ResourceDTO> query = session.createQuery(dobj);
        List<ResourceDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ Resource.getAll - FINISH");
        Map<String, Resource> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(Collection<Resource> toAdd) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ResourceDTO> toPersist = new ArrayList<ResourceDTO>();
        for (Resource req : toAdd) {
            toPersist.add(this.createPersistable(req, session));
        }
        session.savePersistentAll(toPersist);
        session.release(toPersist);
    }

    public void removeAll(Collection<Resource> toRemove) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ResourceDTO> toPersist = new ArrayList<ResourceDTO>();
        for (Resource req : toRemove) {
            Object[] pk = new Object[3];
            pk[0] = req.getId();
            toPersist.add(session.newInstance(ResourceDTO.class, pk));
        }
        session.deletePersistentAll(toPersist);
        session.release(toPersist);
    }

    public void add(Resource resourceNode) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ResourceDTO dto = this.createPersistable(resourceNode, session);
        session.savePersistent(dto);
        session.release(dto);
    }

    private Resource createHopResource(ResourceDTO resourceDTO) {
        if (resourceDTO == null) {
            return null;
        }
        return new Resource(resourceDTO.getId(), resourceDTO.getMemory(), resourceDTO.getVirtualcores(), resourceDTO.getGPUs(), resourceDTO.getpendingeventid());
    }

    private ResourceDTO createPersistable(Resource resource, HopsSession session) throws StorageException {
        ResourceDTO resourceDTO = session.newInstance(ResourceDTO.class);
        resourceDTO.setId(resource.getId());
        resourceDTO.setMemory(resource.getMemory());
        resourceDTO.setVirtualcores(resource.getVirtualCores());
        resourceDTO.setGPUs(resource.getGPUs());
        resourceDTO.setpendingeventid(resource.getPendingEventId());
        return resourceDTO;
    }

    private Map<String, Resource> createMap(List<ResourceDTO> results) {
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        for (ResourceDTO dto : results) {
            Resource hop = this.createHopResource(dto);
            map.put(hop.getId(), hop);
        }
        return map;
    }

    @PersistenceCapable(table="yarn_resource")
    public static interface ResourceDTO {
        @PrimaryKey
        @Column(name="id")
        public String getId();

        public void setId(String var1);

        @Column(name="memory")
        public int getMemory();

        public void setMemory(int var1);

        @Column(name="virtualcores")
        public int getVirtualcores();

        public void setVirtualcores(int var1);

        @Column(name="gpus")
        public int getGPUs();

        public void setGPUs(int var1);

        @Column(name="pendingeventid")
        public int getpendingeventid();

        public void setpendingeventid(int var1);
    }
}

