/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.quota;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.quota.ContainersCheckPointsDataAccess;
import io.hops.metadata.yarn.entity.quota.ContainerCheckPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainersCheckPointsClusterJ
implements TablesDef.ContainersCheckPointsTableDef,
ContainersCheckPointsDataAccess<ContainerCheckPoint> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Map<String, ContainerCheckPoint> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerCheckPointDTO> dobj = qb.createQueryDefinition(ContainerCheckPointDTO.class);
        HopsQuery<ContainerCheckPointDTO> query = session.createQuery(dobj);
        List<ContainerCheckPointDTO> queryResults = query.getResultList();
        Map<String, ContainerCheckPoint> result = ContainersCheckPointsClusterJ.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(List<ContainerCheckPoint> containersCheckPoints) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerCheckPointDTO> toAdd = new ArrayList<ContainerCheckPointDTO>();
        for (ContainerCheckPoint checkPoint : containersCheckPoints) {
            toAdd.add(this.createPersistable(checkPoint, session));
        }
        session.savePersistentAll(toAdd);
        session.release(toAdd);
    }

    public void removeAll(List<ContainerCheckPoint> containersCheckPoints) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerCheckPointDTO> toRemove = new ArrayList<ContainerCheckPointDTO>();
        for (ContainerCheckPoint checkPoint : containersCheckPoints) {
            toRemove.add(this.createPersistable(checkPoint, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    private ContainerCheckPointDTO createPersistable(ContainerCheckPoint checkPoint, HopsSession session) throws StorageException {
        ContainerCheckPointDTO ccpDTO = session.newInstance(ContainerCheckPointDTO.class);
        ccpDTO.setContainerID(checkPoint.getContainerId());
        ccpDTO.setCheckPoint(checkPoint.getCheckPoint());
        ccpDTO.setPrice(checkPoint.getMultiplicator());
        return ccpDTO;
    }

    public static Map<String, ContainerCheckPoint> createMap(List<ContainerCheckPointDTO> dtos) {
        HashMap<String, ContainerCheckPoint> map = new HashMap<String, ContainerCheckPoint>();
        for (ContainerCheckPointDTO dto : dtos) {
            map.put(dto.getContainerID(), new ContainerCheckPoint(dto.getContainerID(), dto.getCheckPoint(), dto.getPrice()));
        }
        return map;
    }

    @PersistenceCapable(table="yarn_containers_checkpoint")
    public static interface ContainerCheckPointDTO {
        @PrimaryKey
        @Column(name="container_id")
        public String getContainerID();

        public void setContainerID(String var1);

        @Column(name="checkpoint")
        public long getCheckPoint();

        public void setCheckPoint(long var1);

        @Column(name="multiplicator")
        public float getPrice();

        public void setPrice(float var1);
    }
}

