/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.rmstatestore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationKeyDataAccess;
import io.hops.metadata.yarn.entity.rmstatestore.DelegationKey;
import io.hops.util.CompressionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;

public class DelegationKeyClusterJ
implements TablesDef.DelegationKeyTableDef,
DelegationKeyDataAccess<DelegationKey> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public void remove(DelegationKey removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        DelegationKeyDTO dto = session.newInstance(DelegationKeyDTO.class, removed.getKey());
        session.deletePersistent(dto);
        session.release(dto);
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(DelegationKeyDTO.class);
    }

    public void add(DelegationKey hopDelegationKey) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        DelegationKeyDTO dto = this.createPersistable(hopDelegationKey, session);
        session.savePersistent(dto);
        session.release(dto);
    }

    public List<DelegationKey> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<DelegationKeyDTO> dobj = qb.createQueryDefinition(DelegationKeyDTO.class);
        HopsQuery<DelegationKeyDTO> query = session.createQuery(dobj);
        List<DelegationKeyDTO> queryResults = query.getResultList();
        List<DelegationKey> result = this.createHopDelegationKeyList(queryResults);
        session.release(queryResults);
        return result;
    }

    private DelegationKey createHopDelegationKey(DelegationKeyDTO delegationKeyDTO) throws StorageException {
        try {
            return new DelegationKey(delegationKeyDTO.getkey(), CompressionUtils.decompress(delegationKeyDTO.getdelegationkey()));
        }
        catch (IOException | DataFormatException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private List<DelegationKey> createHopDelegationKeyList(List<DelegationKeyDTO> list) throws StorageException {
        ArrayList<DelegationKey> hopList = new ArrayList<DelegationKey>();
        for (DelegationKeyDTO dto : list) {
            hopList.add(this.createHopDelegationKey(dto));
        }
        return hopList;
    }

    private DelegationKeyDTO createPersistable(DelegationKey hop, HopsSession session) throws StorageException {
        DelegationKeyDTO delegationKeyDTO = session.newInstance(DelegationKeyDTO.class);
        delegationKeyDTO.setkey(hop.getKey());
        try {
            delegationKeyDTO.setdelegationkey(CompressionUtils.compress(hop.getDelegationkey()));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        return delegationKeyDTO;
    }

    @PersistenceCapable(table="yarn_delegation_key")
    public static interface DelegationKeyDTO {
        @PrimaryKey
        @Column(name="key")
        public int getkey();

        public void setkey(int var1);

        @Column(name="delegationkey")
        public byte[] getdelegationkey();

        public void setdelegationkey(byte[] var1);
    }
}

