/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.exception.UnknownMetadataOperationType;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetadataLogClusterj
implements TablesDef.MetadataLogTableDef,
MetadataLogDataAccess<MetadataLogEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<MetadataLogEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<MetadataLogEntryDto> added = new ArrayList<MetadataLogEntryDto>(logEntries.size());
        ArrayList<DatasetINodeLookupDTO> newLookupDTOS = new ArrayList<DatasetINodeLookupDTO>(logEntries.size());
        try {
            for (MetadataLogEntry logEntry : logEntries) {
                added.add(this.createPersistable(logEntry));
                if (!INodeMetadataLogEntry.isValidOperation((short)logEntry.getOperationId())) continue;
                INodeMetadataLogEntry iNodeLogEntry = (INodeMetadataLogEntry)logEntry;
                DatasetINodeLookupDTO lookupDTO = this.createLookupPersistable(logEntry);
                if (iNodeLogEntry.getOperation() == INodeMetadataLogEntry.Operation.Add) {
                    newLookupDTOS.add(lookupDTO);
                    continue;
                }
                if (iNodeLogEntry.getOperation() != INodeMetadataLogEntry.Operation.Delete) continue;
                session.deletePersistent(lookupDTO);
                session.release(lookupDTO);
            }
            session.makePersistentAll(added);
            session.savePersistentAll(newLookupDTOS);
        }
        finally {
            session.release(added);
            session.release(newLookupDTOS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MetadataLogEntry metadataLogEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        MetadataLogEntryDto dto = null;
        DatasetINodeLookupDTO lookupDTO = null;
        try {
            dto = this.createPersistable(metadataLogEntry);
            session.makePersistent(dto);
            if (INodeMetadataLogEntry.isValidOperation((short)metadataLogEntry.getOperationId())) {
                lookupDTO = this.createLookupPersistable(metadataLogEntry);
                INodeMetadataLogEntry iNodeMetadataLogEntry = (INodeMetadataLogEntry)metadataLogEntry;
                if (iNodeMetadataLogEntry.getOperation() == INodeMetadataLogEntry.Operation.Add) {
                    session.savePersistent(lookupDTO);
                } else if (iNodeMetadataLogEntry.getOperation() == INodeMetadataLogEntry.Operation.Delete) {
                    session.deletePersistent(lookupDTO);
                }
            }
        }
        finally {
            session.release(dto);
            session.release(lookupDTO);
        }
    }

    private MetadataLogEntryDto createPersistable(MetadataLogEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        MetadataLogEntryDto dto = session.newInstance(MetadataLogEntryDto.class);
        dto.setDatasetId(logEntry.getDatasetId());
        dto.setInodeId(logEntry.getInodeId());
        dto.setPk1(logEntry.getPk1());
        dto.setPk2(logEntry.getPk2());
        dto.setPk3(logEntry.getPk3());
        dto.setLogicalTime(logEntry.getLogicalTime());
        dto.setOperation(logEntry.getOperationId());
        return dto;
    }

    private DatasetINodeLookupDTO createLookupPersistable(MetadataLogEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        DatasetINodeLookupDTO dto = session.newInstance(DatasetINodeLookupDTO.class);
        dto.setDatasetId(logEntry.getDatasetId());
        dto.setInodeId(logEntry.getInodeId());
        return dto;
    }

    public Collection<MetadataLogEntry> find(long fileId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<MetadataLogEntryDto> dobj = qb.createQueryDefinition(MetadataLogEntryDto.class);
        HopsPredicate pred1 = dobj.get("inodeId").equal(dobj.param("inodeIdParam"));
        dobj.where(pred1);
        HopsQuery<MetadataLogEntryDto> query = session.createQuery(dobj);
        query.setParameter("inodeIdParam", fileId);
        List<MetadataLogEntryDto> dtos = query.getResultList();
        Collection<MetadataLogEntry> mlel = this.createCollection(dtos);
        session.release(dtos);
        return mlel;
    }

    private Collection<MetadataLogEntry> createCollection(Collection<MetadataLogEntryDto> collection) throws UnknownMetadataOperationType {
        ArrayList<MetadataLogEntry> list = new ArrayList<MetadataLogEntry>(collection.size());
        for (MetadataLogEntryDto dto : collection) {
            list.add(this.createMetadataLogEntry(dto));
        }
        return list;
    }

    private MetadataLogEntry createMetadataLogEntry(MetadataLogEntryDto dto) throws UnknownMetadataOperationType {
        return MetadataLogEntry.newEntry((long)dto.getDatasetId(), (long)dto.getInodeId(), (int)dto.getLogicalTime(), (long)dto.getPk1(), (long)dto.getPk2(), (String)dto.getPk3(), (short)dto.getOperation());
    }

    @PersistenceCapable(table="hdfs_inode_dataset_lookup")
    public static interface DatasetINodeLookupDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @Column(name="dataset_id")
        public long getDatasetId();

        public void setDatasetId(long var1);
    }

    @PersistenceCapable(table="hdfs_metadata_log")
    public static interface MetadataLogEntryDto {
        @PrimaryKey
        @Column(name="dataset_id")
        public long getDatasetId();

        public void setDatasetId(long var1);

        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @PrimaryKey
        @Column(name="logical_time")
        public int getLogicalTime();

        public void setLogicalTime(int var1);

        @Column(name="pk1")
        public long getPk1();

        public void setPk1(long var1);

        @Column(name="pk2")
        public long getPk2();

        public void setPk2(long var1);

        @Column(name="pk3")
        public String getPk3();

        public void setPk3(String var1);

        @Column(name="operation")
        public short getOperation();

        public void setOperation(short var1);
    }
}

