/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.ContainerToSignalDataAccess;
import io.hops.metadata.yarn.entity.ContainerToSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContainerToSignalClusterJ
implements TablesDef.ContainerToSignalTableDef,
ContainerToSignalDataAccess<ContainerToSignal> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<ContainerToSignal> findByRMNode(String rmnodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerToSignalDTO> dobj = qb.createQueryDefinition(ContainerToSignalDTO.class);
        HopsPredicate pred = dobj.get("rmnodeid").equal(dobj.param("rmnodeid"));
        dobj.where(pred);
        HopsQuery<ContainerToSignalDTO> query = session.createQuery(dobj);
        query.setParameter("rmnodeid", rmnodeId);
        List<ContainerToSignalDTO> queryResults = query.getResultList();
        if (queryResults != null && !queryResults.isEmpty()) {
            List<ContainerToSignal> results = this.createContainersToSignalList(queryResults);
            session.release(queryResults);
            return results;
        }
        return null;
    }

    public Map<String, Set<ContainerToSignal>> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ContainerToSignalDTO> dobj = qb.createQueryDefinition(ContainerToSignalDTO.class);
        HopsQuery<ContainerToSignalDTO> query = session.createQuery(dobj);
        List<ContainerToSignalDTO> queryResults = query.getResultList();
        Map<String, Set<ContainerToSignal>> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public void addAll(Collection<ContainerToSignal> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerToSignalDTO> toModify = new ArrayList<ContainerToSignalDTO>();
        for (ContainerToSignal hop : containers) {
            toModify.add(this.createPersistable(hop, session));
        }
        session.savePersistentAll(toModify);
        session.release(toModify);
    }

    public void add(ContainerToSignal container) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ContainerToSignalDTO toModify = this.createPersistable(container, session);
        session.savePersistent(toModify);
        session.release(toModify);
    }

    public void removeAll(Collection<ContainerToSignal> containers) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ContainerToSignalDTO> toRemove = new ArrayList<ContainerToSignalDTO>();
        for (ContainerToSignal hop : containers) {
            toRemove.add(this.createPersistable(hop, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    private ContainerToSignalDTO createPersistable(ContainerToSignal hop, HopsSession session) throws StorageException {
        ContainerToSignalDTO dto = session.newInstance(ContainerToSignalDTO.class);
        dto.setRmnodeid(hop.getRmnodeid());
        dto.setContainerid(hop.getContainerId());
        dto.setCommand(hop.getCommand());
        return dto;
    }

    private ContainerToSignal createHopContainerIdToClean(ContainerToSignalDTO dto) {
        ContainerToSignal hop = new ContainerToSignal(dto.getRmnodeid(), dto.getContainerid(), dto.getCommand());
        return hop;
    }

    private List<ContainerToSignal> createContainersToSignalList(List<ContainerToSignalDTO> results) {
        ArrayList<ContainerToSignal> containersToClean = new ArrayList<ContainerToSignal>();
        for (ContainerToSignalDTO persistable : results) {
            containersToClean.add(this.createHopContainerIdToClean(persistable));
        }
        return containersToClean;
    }

    private Map<String, Set<ContainerToSignal>> createMap(List<ContainerToSignalDTO> results) {
        HashMap<String, Set<ContainerToSignal>> map = new HashMap<String, Set<ContainerToSignal>>();
        for (ContainerToSignalDTO dto : results) {
            ContainerToSignal hop = this.createHopContainerIdToClean(dto);
            if (map.get(hop.getRmnodeid()) == null) {
                map.put(hop.getRmnodeid(), new HashSet());
            }
            ((Set)map.get(hop.getRmnodeid())).add(hop);
        }
        return map;
    }

    @PersistenceCapable(table="yarn_container_to_signal")
    public static interface ContainerToSignalDTO {
        @PrimaryKey
        @Column(name="rmnodeid")
        public String getRmnodeid();

        public void setRmnodeid(String var1);

        @PrimaryKey
        @Column(name="containerid")
        public String getContainerid();

        public void setContainerid(String var1);

        @PrimaryKey
        @Column(name="command")
        public String getCommand();

        public void setCommand(String var1);
    }
}

