/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.rmstatestore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationAttemptStateDataAccess;
import io.hops.metadata.yarn.entity.rmstatestore.ApplicationAttemptState;
import io.hops.util.CompressionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public class ApplicationAttemptStateClusterJ
implements TablesDef.ApplicationAttemptStateTableDef,
ApplicationAttemptStateDataAccess<ApplicationAttemptState> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Map<String, List<ApplicationAttemptState>> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ApplicationAttemptStateDTO> dobj = qb.createQueryDefinition(ApplicationAttemptStateDTO.class);
        HopsQuery<ApplicationAttemptStateDTO> query = session.createQuery(dobj);
        List<ApplicationAttemptStateDTO> queryResults = query.getResultList();
        Map<String, List<ApplicationAttemptState>> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public List<ApplicationAttemptState> getByAppId(String appId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ApplicationAttemptStateDTO> dobj = qb.createQueryDefinition(ApplicationAttemptStateDTO.class);
        HopsPredicate pred1 = dobj.get("applicationid").equal(dobj.param("applicationid"));
        HopsQuery<ApplicationAttemptStateDTO> query = session.createQuery(dobj);
        query.setParameter("applicationid", appId);
        List<ApplicationAttemptStateDTO> queryResults = query.getResultList();
        List<ApplicationAttemptState> result = this.createList(queryResults);
        session.release(queryResults);
        return result;
    }

    public void add(ApplicationAttemptState entry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.savePersistent(this.createPersistable(entry, session));
    }

    public void removeAll(Collection<ApplicationAttemptState> removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ApplicationAttemptStateDTO> toRemove = new ArrayList<ApplicationAttemptStateDTO>();
        for (ApplicationAttemptState hop : removed) {
            Object[] objarr = new Object[]{hop.getApplicationId(), hop.getApplicationattemptid()};
            toRemove.add(session.newInstance(ApplicationAttemptStateDTO.class, objarr));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(ApplicationAttemptStateDTO.class);
    }

    private ApplicationAttemptState createHopApplicationAttemptState(ApplicationAttemptStateDTO entry) throws StorageException {
        try {
            return new ApplicationAttemptState(entry.getapplicationid(), entry.getapplicationattemptid(), CompressionUtils.decompress(entry.getapplicationattemptstate()), entry.gettrakingurl());
        }
        catch (IOException | DataFormatException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private ApplicationAttemptStateDTO createPersistable(ApplicationAttemptState hop, HopsSession session) throws StorageException {
        ApplicationAttemptStateDTO applicationAttemptStateDTO = session.newInstance(ApplicationAttemptStateDTO.class);
        applicationAttemptStateDTO.setapplicationid(hop.getApplicationId());
        applicationAttemptStateDTO.setapplicationattemptid(hop.getApplicationattemptid());
        applicationAttemptStateDTO.settrakingurl(hop.getTrakingURL());
        try {
            applicationAttemptStateDTO.setapplicationattemptstate(CompressionUtils.compress(hop.getApplicationattemptstate()));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        return applicationAttemptStateDTO;
    }

    private Map<String, List<ApplicationAttemptState>> createMap(List<ApplicationAttemptStateDTO> results) throws StorageException {
        HashMap<String, List<ApplicationAttemptState>> map = new HashMap<String, List<ApplicationAttemptState>>();
        for (ApplicationAttemptStateDTO persistable : results) {
            ApplicationAttemptState hop = this.createHopApplicationAttemptState(persistable);
            if (map.get(hop.getApplicationId()) == null) {
                map.put(hop.getApplicationId(), new ArrayList());
            }
            ((List)map.get(hop.getApplicationId())).add(hop);
        }
        return map;
    }

    private List<ApplicationAttemptState> createList(List<ApplicationAttemptStateDTO> results) throws StorageException {
        ArrayList<ApplicationAttemptState> list = new ArrayList<ApplicationAttemptState>();
        for (ApplicationAttemptStateDTO persistable : results) {
            ApplicationAttemptState hop = this.createHopApplicationAttemptState(persistable);
            list.add(hop);
        }
        return list;
    }

    @PersistenceCapable(table="yarn_applicationattemptstate")
    public static interface ApplicationAttemptStateDTO {
        @PrimaryKey
        @Column(name="applicationid")
        public String getapplicationid();

        public void setapplicationid(String var1);

        @Column(name="applicationattemptid")
        public String getapplicationattemptid();

        public void setapplicationattemptid(String var1);

        @Column(name="applicationattemptstate")
        public byte[] getapplicationattemptstate();

        public void setapplicationattemptstate(byte[] var1);

        @Column(name="applicationattempttrakingurl")
        public String gettrakingurl();

        public void settrakingurl(String var1);
    }
}

