/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.mysqlserver;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.ScriptRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MysqlServerConnector
implements StorageConnector<Connection> {
    static final Log LOG = LogFactory.getLog(MysqlServerConnector.class);
    private static final MysqlServerConnector instance = new MysqlServerConnector();
    private Properties conf;
    private static volatile HikariDataSource connectionPool;
    private ThreadLocal<Connection> connection = new ThreadLocal();

    public static MysqlServerConnector getInstance() {
        return instance;
    }

    public void setConfiguration(Properties conf) throws StorageException {
        this.conf = conf;
    }

    private void initializeConnectionPool(Properties conf) {
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(Integer.valueOf(conf.getProperty("io.hops.metadata.ndb.mysqlserver.connection_pool_size")).intValue());
        config.setDataSourceClassName(conf.getProperty("io.hops.metadata.ndb.mysqlserver.data_source_class_name"));
        config.addDataSourceProperty("serverName", (Object)conf.getProperty("io.hops.metadata.ndb.mysqlserver.host"));
        config.addDataSourceProperty("port", (Object)conf.getProperty("io.hops.metadata.ndb.mysqlserver.port"));
        config.addDataSourceProperty("databaseName", (Object)conf.getProperty("com.mysql.clusterj.database"));
        config.addDataSourceProperty("user", (Object)conf.getProperty("io.hops.metadata.ndb.mysqlserver.username"));
        config.addDataSourceProperty("password", (Object)conf.getProperty("io.hops.metadata.ndb.mysqlserver.password"));
        connectionPool = new HikariDataSource(config);
    }

    public Connection obtainSession() throws StorageException {
        Connection conn = this.connection.get();
        if (conn == null) {
            HikariDataSource connectionPool = this.getConnectionPool();
            try {
                conn = connectionPool.getConnection();
                this.connection.set(conn);
            }
            catch (SQLException ex) {
                throw HopsSQLExceptionHelper.wrap(ex);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HikariDataSource getConnectionPool() {
        if (connectionPool == null) {
            MysqlServerConnector mysqlServerConnector = this;
            synchronized (mysqlServerConnector) {
                if (connectionPool == null) {
                    this.initializeConnectionPool(this.conf);
                }
            }
        }
        return connectionPool;
    }

    public void closeSession() throws StorageException {
        Connection conn = this.connection.get();
        if (conn != null) {
            try {
                conn.close();
                this.connection.remove();
            }
            catch (SQLException ex) {
                throw HopsSQLExceptionHelper.wrap(ex);
            }
        }
    }

    public static void truncateTable(boolean transactional, String tableName) throws StorageException, SQLException {
        MysqlServerConnector.truncateTable(transactional, tableName, -1);
    }

    public static void truncateTable(String tableName, int limit) throws StorageException, SQLException {
        MysqlServerConnector.truncateTable(true, tableName, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateTable(boolean transactional, String tableName, int limit) throws StorageException, SQLException {
        MysqlServerConnector connector = MysqlServerConnector.getInstance();
        try {
            Connection conn = connector.obtainSession();
            if (transactional) {
                if (limit > 0) {
                    PreparedStatement s = conn.prepareStatement("delete from " + tableName + " limit " + limit);
                    s.executeUpdate();
                } else {
                    PreparedStatement s;
                    int nbrows = 0;
                    while ((nbrows = (s = conn.prepareStatement("delete from " + tableName + " limit 1000")).executeUpdate()) > 0) {
                    }
                }
            } else {
                PreparedStatement s = conn.prepareStatement("truncate table " + tableName);
                s.executeUpdate();
            }
        }
        finally {
            connector.closeSession();
        }
    }

    public void returnSession(boolean error) throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void beginTransaction() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void commit() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void rollback() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatStorage() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatYarnStorage() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatHDFSStorage() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatStorage(Class<? extends EntityDataAccess> ... das) throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isTransactionActive() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stopStorage() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void readLock() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeLock() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void readCommitted() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPartitionKey(Class className, Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatAllStorageNonTransactional() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatYarnStorageNonTransactional() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean formatHDFSStorageNonTransactional() throws StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAndRecreateDB() throws StorageException {
        MysqlServerConnector connector = MysqlServerConnector.getInstance();
        try {
            Connection conn = null;
            Statement stmt = null;
            String sql = "";
            String database = this.conf.getProperty("com.mysql.clusterj.database");
            try {
                conn = connector.obtainSession();
                stmt = conn.createStatement();
                sql = "DROP DATABASE IF EXISTS " + database;
                LOG.warn((Object)("Dropping database " + database));
                stmt.executeUpdate(sql);
                LOG.warn((Object)"Database dropped");
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                sql = "CREATE DATABASE  " + database;
                LOG.warn((Object)("Creating database " + database));
                stmt.executeUpdate(sql);
                LOG.warn((Object)"Database created");
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                sql = "use  " + database;
                LOG.warn((Object)("Selectign database " + database));
                stmt.executeUpdate(sql);
                LOG.warn((Object)"Database selected");
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
            try {
                ScriptRunner runner = new ScriptRunner(conn, false, false);
                LOG.warn((Object)"Importing Database");
                runner.runScript(new BufferedReader(new InputStreamReader(this.getSchema())));
                LOG.warn((Object)"Schema imported");
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
        }
        finally {
            connector.closeSession();
        }
    }

    public InputStream getSchema() throws IOException {
        String configFile = "schema.sql";
        InputStream inStream = StorageConnector.class.getClassLoader().getResourceAsStream(configFile);
        return inStream;
    }

    public void flush() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getClusterConnectString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDatabaseName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean hasResources(final double threshold) throws StorageException {
        return MySQLQueryHelper.execute("SELECT memory_type, used, total FROM ndbinfo.memoryusage where memory_type = \"Data memory\"", new MySQLQueryHelper.ResultSetHandler<Boolean>(){

            @Override
            public Boolean handle(ResultSet result) throws SQLException, StorageException {
                boolean hasResource = true;
                while (result.next()) {
                    long total;
                    String memoryType = result.getString("memory_type");
                    long used = result.getLong("used");
                    hasResource = (double)used < (double)(total = result.getLong("total")) * threshold;
                    if (hasResource) continue;
                    LOG.error((Object)("NDB " + memoryType + " is  " + threshold * 100.0 + "% full (" + used + "/" + total + ")"));
                    break;
                }
                return hasResource;
            }
        });
    }
}

