/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Lists;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.hdfs.VariableClusterj;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class XAttrClusterJ
implements TablesDef.XAttrTableDef,
XAttrDataAccess<StoredXAttr, StoredXAttr.PrimaryKey> {
    static final Logger LOG = Logger.getLogger(VariableClusterj.class);
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoredXAttr> getXAttrsByPrimaryKeyBatch(List<StoredXAttr.PrimaryKey> pks) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList dtos = Lists.newArrayListWithExpectedSize((int)pks.size());
        try {
            for (StoredXAttr.PrimaryKey pk : pks) {
                XAttrDTO dto = session.newInstance(XAttrDTO.class, new Object[]{pk.getInodeId(), pk.getNamespace(), pk.getName()});
                session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            List<StoredXAttr> list = this.convertAndCheck(session, dtos);
            return list;
        }
        finally {
            session.release(dtos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StoredXAttr> getXAttrsByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<XAttrDTO> dobj = qb.createQueryDefinition(XAttrDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("idParam"));
        dobj.where(pred1);
        HopsQuery<XAttrDTO> query = session.createQuery(dobj);
        query.setParameter("idParam", inodeId);
        List<XAttrDTO> results = null;
        try {
            results = query.getResultList();
            if (results.isEmpty()) {
                Collection<StoredXAttr> collection = null;
                return collection;
            }
            List<StoredXAttr> list = this.convert(results);
            return list;
        }
        finally {
            session.release(results);
        }
    }

    public int removeXAttrsByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<XAttrDTO> dobj = qb.createQueryDefinition(XAttrDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("idParam"));
        dobj.where(pred1);
        HopsQuery<XAttrDTO> query = session.createQuery(dobj);
        query.setParameter("idParam", inodeId);
        return query.deletePersistentAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<StoredXAttr> removed, Collection<StoredXAttr> newed, Collection<StoredXAttr> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<XAttrDTO> changes = new ArrayList<XAttrDTO>();
        ArrayList<XAttrDTO> deletions = new ArrayList<XAttrDTO>();
        try {
            XAttrDTO persistable;
            for (StoredXAttr xattr : removed) {
                persistable = this.createPersistable(session, xattr);
                deletions.add(persistable);
            }
            for (StoredXAttr xattr : newed) {
                persistable = this.createPersistable(session, xattr);
                changes.add(persistable);
            }
            for (StoredXAttr xattr : modified) {
                persistable = this.createPersistable(session, xattr);
                changes.add(persistable);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private XAttrDTO createPersistable(HopsSession session, StoredXAttr xattr) throws StorageException {
        XAttrDTO dto = session.newInstance(XAttrDTO.class);
        dto.setINodeId(xattr.getInodeId());
        dto.setNamespace(xattr.getNamespace());
        dto.setName(xattr.getName());
        dto.setValue(xattr.getValue() == null ? "" : xattr.getValue());
        return dto;
    }

    private List<StoredXAttr> convert(List<XAttrDTO> dtos) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)dtos.size());
        for (XAttrDTO dto : dtos) {
            results.add(this.convert(dto));
        }
        return results;
    }

    private List<StoredXAttr> convertAndCheck(HopsSession session, List<XAttrDTO> dtos) throws StorageException {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)dtos.size());
        for (XAttrDTO dto : dtos) {
            if (dto.getValue() == null) continue;
            results.add(this.convert(dto));
        }
        return results;
    }

    private StoredXAttr convert(XAttrDTO dto) {
        return new StoredXAttr(dto.getINodeId(), dto.getNamespace(), dto.getName(), dto.getValue().isEmpty() ? null : dto.getValue());
    }

    @PersistenceCapable(table="hdfs_xattrs")
    public static interface XAttrDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="namespace")
        public byte getNamespace();

        public void setNamespace(byte var1);

        @PrimaryKey
        @Column(name="name")
        public String getName();

        public void setName(String var1);

        @Column(name="value")
        public String getValue();

        public void setValue(String var1);
    }
}

