/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.DirectoryWithQuotaFeatureDataAccess;
import io.hops.metadata.hdfs.entity.DirectoryWithQuotaFeature;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class DirectoryWithQuotaFeatureClusterj
implements TablesDef.DirectoryWithQuotaFeatureTableDef,
DirectoryWithQuotaFeatureDataAccess<DirectoryWithQuotaFeature> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public DirectoryWithQuotaFeature findAttributesByPk(Long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        INodeAttributesDTO dto = session.find(INodeAttributesDTO.class, inodeId);
        DirectoryWithQuotaFeature iNodeAttributes = null;
        if (dto != null) {
            iNodeAttributes = this.makeINodeAttributes(dto);
            session.release(dto);
        }
        return iNodeAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DirectoryWithQuotaFeature> findAttributesByPkList(List<INodeCandidatePrimaryKey> inodePks) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<DirectoryWithQuotaFeature> inodeAttributesBatchResponse = new ArrayList<DirectoryWithQuotaFeature>();
        ArrayList<INodeAttributesDTO> inodeAttributesBatchRequest = new ArrayList<INodeAttributesDTO>();
        try {
            for (INodeCandidatePrimaryKey pk : inodePks) {
                INodeAttributesDTO dto = session.newInstance(INodeAttributesDTO.class);
                dto.setId(pk.getInodeId());
                inodeAttributesBatchRequest.add(dto);
                session.load(dto);
            }
            session.flush();
            for (INodeAttributesDTO anInodeAttributesBatchRequest : inodeAttributesBatchRequest) {
                inodeAttributesBatchResponse.add(this.makeINodeAttributes(anInodeAttributesBatchRequest));
            }
            ArrayList<DirectoryWithQuotaFeature> arrayList = inodeAttributesBatchResponse;
            return arrayList;
        }
        finally {
            session.release(inodeAttributesBatchRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<DirectoryWithQuotaFeature> modified, Collection<DirectoryWithQuotaFeature> removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<INodeAttributesDTO> changes = new ArrayList<INodeAttributesDTO>();
        ArrayList<INodeAttributesDTO> deletions = new ArrayList<INodeAttributesDTO>();
        try {
            INodeAttributesDTO persistable;
            if (removed != null) {
                for (DirectoryWithQuotaFeature attr : removed) {
                    persistable = session.newInstance(INodeAttributesDTO.class, attr.getInodeId());
                    deletions.add(persistable);
                }
            }
            if (modified != null) {
                for (DirectoryWithQuotaFeature attr : modified) {
                    persistable = this.createPersistable(attr, session);
                    changes.add(persistable);
                }
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private INodeAttributesDTO createPersistable(DirectoryWithQuotaFeature dir, HopsSession session) throws StorageException {
        INodeAttributesDTO dto = session.newInstance(INodeAttributesDTO.class);
        dto.setId(dir.getInodeId());
        dto.setNSQuota(dir.getNsQuota());
        dto.setNSCount(dir.getNsUsed());
        dto.setSSQuota(dir.getSSQuota());
        dto.setStorageSpace(dir.getSSUsed());
        dto.setTypeSpaceQuotaDisk((Long)dir.getTypeQuota().get(QuotaUpdate.StorageType.DISK));
        dto.setTypeSpaceQuotaSSD((Long)dir.getTypeQuota().get(QuotaUpdate.StorageType.SSD));
        dto.setTypeSpaceQuotaRaid5((Long)dir.getTypeQuota().get(QuotaUpdate.StorageType.RAID5));
        dto.setTypeSpaceQuotaArchive((Long)dir.getTypeQuota().get(QuotaUpdate.StorageType.ARCHIVE));
        dto.setTypeSpaceQuotaDb((Long)dir.getTypeQuota().get(QuotaUpdate.StorageType.DB));
        dto.setTypeSpaceUsedDisk((Long)dir.getTypeUsed().get(QuotaUpdate.StorageType.DISK));
        dto.setTypeSpaceUsedSSD((Long)dir.getTypeUsed().get(QuotaUpdate.StorageType.SSD));
        dto.setTypeSpaceUsedRaid5((Long)dir.getTypeUsed().get(QuotaUpdate.StorageType.RAID5));
        dto.setTypeSpaceUsedArchive((Long)dir.getTypeUsed().get(QuotaUpdate.StorageType.ARCHIVE));
        dto.setTypeSpaceUsedDb((Long)dir.getTypeUsed().get(QuotaUpdate.StorageType.DB));
        return dto;
    }

    private DirectoryWithQuotaFeature makeINodeAttributes(INodeAttributesDTO dto) {
        if (dto == null) {
            return null;
        }
        HashMap<QuotaUpdate.StorageType, Long> typeQuota = new HashMap<QuotaUpdate.StorageType, Long>();
        typeQuota.put(QuotaUpdate.StorageType.DISK, dto.getTypeSpaceQuotaDisk());
        typeQuota.put(QuotaUpdate.StorageType.SSD, dto.getTypeSpaceQuotaSSD());
        typeQuota.put(QuotaUpdate.StorageType.RAID5, dto.getTypeSpaceQuotaRaid5());
        typeQuota.put(QuotaUpdate.StorageType.ARCHIVE, dto.getTypeSpaceQuotaArchive());
        typeQuota.put(QuotaUpdate.StorageType.DB, dto.getTypeSpaceQuotaDb());
        HashMap<QuotaUpdate.StorageType, Long> typeUsed = new HashMap<QuotaUpdate.StorageType, Long>();
        typeUsed.put(QuotaUpdate.StorageType.DISK, dto.getTypeSpaceUsedDisk());
        typeUsed.put(QuotaUpdate.StorageType.SSD, dto.getTypeSpaceUsedSSD());
        typeUsed.put(QuotaUpdate.StorageType.RAID5, dto.getTypeSpaceUsedRaid5());
        typeUsed.put(QuotaUpdate.StorageType.ARCHIVE, dto.getTypeSpaceUsedArchive());
        typeUsed.put(QuotaUpdate.StorageType.DB, dto.getTypeSpaceUsedDb());
        DirectoryWithQuotaFeature dir = new DirectoryWithQuotaFeature(Long.valueOf(dto.getId()), Long.valueOf(dto.getNSQuota()), Long.valueOf(dto.getNSCount()), Long.valueOf(dto.getSSQuota()), Long.valueOf(dto.getStorageSpace()), typeQuota, typeUsed);
        return dir;
    }

    @PersistenceCapable(table="hdfs_directory_with_quota_feature")
    public static interface INodeAttributesDTO {
        @PrimaryKey
        @Column(name="inodeId")
        public long getId();

        public void setId(long var1);

        @Column(name="nsquota")
        public long getNSQuota();

        public void setNSQuota(long var1);

        @Column(name="ssquota")
        public long getSSQuota();

        public void setSSQuota(long var1);

        @Column(name="nscount")
        public long getNSCount();

        public void setNSCount(long var1);

        @Column(name="storage_space")
        public long getStorageSpace();

        public void setStorageSpace(long var1);

        @Column(name="typespace_quota_disk")
        public long getTypeSpaceQuotaDisk();

        public void setTypeSpaceQuotaDisk(long var1);

        @Column(name="typespace_quota_ssd")
        public long getTypeSpaceQuotaSSD();

        public void setTypeSpaceQuotaSSD(long var1);

        @Column(name="typespace_quota_raid5")
        public long getTypeSpaceQuotaRaid5();

        public void setTypeSpaceQuotaRaid5(long var1);

        @Column(name="typespace_quota_archive")
        public long getTypeSpaceQuotaArchive();

        public void setTypeSpaceQuotaArchive(long var1);

        @Column(name="typespace_quota_db")
        public long getTypeSpaceQuotaDb();

        public void setTypeSpaceQuotaDb(long var1);

        @Column(name="typespace_used_disk")
        public long getTypeSpaceUsedDisk();

        public void setTypeSpaceUsedDisk(long var1);

        @Column(name="typespace_used_ssd")
        public long getTypeSpaceUsedSSD();

        public void setTypeSpaceUsedSSD(long var1);

        @Column(name="typespace_used_raid5")
        public long getTypeSpaceUsedRaid5();

        public void setTypeSpaceUsedRaid5(long var1);

        @Column(name="typespace_used_archive")
        public long getTypeSpaceUsedArchive();

        public void setTypeSpaceUsedArchive(long var1);

        @Column(name="typespace_used_db")
        public long getTypeSpaceUsedDb();

        public void setTypeSpaceUsedDb(long var1);
    }
}

